/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.FlexVolumeBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.flexvolume.SecretRef;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"driver", "fsType", "options", "readOnly", "secretRef"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class FlexVolume
implements Editable<FlexVolumeBuilder>,
KubernetesResource {
    @JsonProperty(value="driver")
    @Required
    @JsonPropertyDescription(value="driver is the name of the driver to use for this volume.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String driver;
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="options")
    @JsonPropertyDescription(value="options is Optional: this field holds extra command options if any.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> options;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @JsonPropertyDescription(value="secretRef is Optional: secretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;

    public FlexVolumeBuilder edit() {
        return new FlexVolumeBuilder(this);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public String toString() {
        return "FlexVolume(driver=" + this.getDriver() + ", fsType=" + this.getFsType() + ", options=" + this.getOptions() + ", readOnly=" + this.getReadOnly() + ", secretRef=" + this.getSecretRef() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlexVolume)) {
            return false;
        }
        FlexVolume other = (FlexVolume)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        Map<String, String> this$options = this.getOptions();
        Map<String, String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        SecretRef this$secretRef = this.getSecretRef();
        SecretRef other$secretRef = other.getSecretRef();
        return !(this$secretRef == null ? other$secretRef != null : !((Object)this$secretRef).equals(other$secretRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlexVolume;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        Map<String, String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        SecretRef $secretRef = this.getSecretRef();
        result = result * 59 + ($secretRef == null ? 43 : ((Object)$secretRef).hashCode());
        return result;
    }
}

