/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.IscsiBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.iscsi.SecretRef;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"chapAuthDiscovery", "chapAuthSession", "fsType", "initiatorName", "iqn", "iscsiInterface", "lun", "portals", "readOnly", "secretRef", "targetPortal"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Iscsi
implements Editable<IscsiBuilder>,
KubernetesResource {
    @JsonProperty(value="chapAuthDiscovery")
    @JsonPropertyDescription(value="chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean chapAuthDiscovery;
    @JsonProperty(value="chapAuthSession")
    @JsonPropertyDescription(value="chapAuthSession defines whether support iSCSI Session CHAP authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean chapAuthSession;
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi TODO: how do we prevent errors in the filesystem from compromising the machine")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="initiatorName")
    @JsonPropertyDescription(value="initiatorName is the custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String initiatorName;
    @JsonProperty(value="iqn")
    @Required
    @JsonPropertyDescription(value="iqn is the target iSCSI Qualified Name.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String iqn;
    @JsonProperty(value="iscsiInterface")
    @JsonPropertyDescription(value="iscsiInterface is the interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String iscsiInterface;
    @JsonProperty(value="lun")
    @Required
    @JsonPropertyDescription(value="lun represents iSCSI Target Lun number.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer lun;
    @JsonProperty(value="portals")
    @JsonPropertyDescription(value="portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> portals;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @JsonPropertyDescription(value="secretRef is the CHAP Secret for iSCSI target and initiator authentication")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="targetPortal")
    @Required
    @JsonPropertyDescription(value="targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String targetPortal;

    public IscsiBuilder edit() {
        return new IscsiBuilder(this);
    }

    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    public void setChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
    }

    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    public void setChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getInitiatorName() {
        return this.initiatorName;
    }

    public void setInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
    }

    public String getIqn() {
        return this.iqn;
    }

    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public void setIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
    }

    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public List<String> getPortals() {
        return this.portals;
    }

    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public String getTargetPortal() {
        return this.targetPortal;
    }

    public void setTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
    }

    public String toString() {
        return "Iscsi(chapAuthDiscovery=" + this.getChapAuthDiscovery() + ", chapAuthSession=" + this.getChapAuthSession() + ", fsType=" + this.getFsType() + ", initiatorName=" + this.getInitiatorName() + ", iqn=" + this.getIqn() + ", iscsiInterface=" + this.getIscsiInterface() + ", lun=" + this.getLun() + ", portals=" + this.getPortals() + ", readOnly=" + this.getReadOnly() + ", secretRef=" + this.getSecretRef() + ", targetPortal=" + this.getTargetPortal() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Iscsi)) {
            return false;
        }
        Iscsi other = (Iscsi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$chapAuthDiscovery = this.getChapAuthDiscovery();
        Boolean other$chapAuthDiscovery = other.getChapAuthDiscovery();
        if (this$chapAuthDiscovery == null ? other$chapAuthDiscovery != null : !((Object)this$chapAuthDiscovery).equals(other$chapAuthDiscovery)) {
            return false;
        }
        Boolean this$chapAuthSession = this.getChapAuthSession();
        Boolean other$chapAuthSession = other.getChapAuthSession();
        if (this$chapAuthSession == null ? other$chapAuthSession != null : !((Object)this$chapAuthSession).equals(other$chapAuthSession)) {
            return false;
        }
        Integer this$lun = this.getLun();
        Integer other$lun = other.getLun();
        if (this$lun == null ? other$lun != null : !((Object)this$lun).equals(other$lun)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        String this$initiatorName = this.getInitiatorName();
        String other$initiatorName = other.getInitiatorName();
        if (this$initiatorName == null ? other$initiatorName != null : !this$initiatorName.equals(other$initiatorName)) {
            return false;
        }
        String this$iqn = this.getIqn();
        String other$iqn = other.getIqn();
        if (this$iqn == null ? other$iqn != null : !this$iqn.equals(other$iqn)) {
            return false;
        }
        String this$iscsiInterface = this.getIscsiInterface();
        String other$iscsiInterface = other.getIscsiInterface();
        if (this$iscsiInterface == null ? other$iscsiInterface != null : !this$iscsiInterface.equals(other$iscsiInterface)) {
            return false;
        }
        List<String> this$portals = this.getPortals();
        List<String> other$portals = other.getPortals();
        if (this$portals == null ? other$portals != null : !((Object)this$portals).equals(other$portals)) {
            return false;
        }
        SecretRef this$secretRef = this.getSecretRef();
        SecretRef other$secretRef = other.getSecretRef();
        if (this$secretRef == null ? other$secretRef != null : !((Object)this$secretRef).equals(other$secretRef)) {
            return false;
        }
        String this$targetPortal = this.getTargetPortal();
        String other$targetPortal = other.getTargetPortal();
        return !(this$targetPortal == null ? other$targetPortal != null : !this$targetPortal.equals(other$targetPortal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Iscsi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $chapAuthDiscovery = this.getChapAuthDiscovery();
        result = result * 59 + ($chapAuthDiscovery == null ? 43 : ((Object)$chapAuthDiscovery).hashCode());
        Boolean $chapAuthSession = this.getChapAuthSession();
        result = result * 59 + ($chapAuthSession == null ? 43 : ((Object)$chapAuthSession).hashCode());
        Integer $lun = this.getLun();
        result = result * 59 + ($lun == null ? 43 : ((Object)$lun).hashCode());
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        String $initiatorName = this.getInitiatorName();
        result = result * 59 + ($initiatorName == null ? 43 : $initiatorName.hashCode());
        String $iqn = this.getIqn();
        result = result * 59 + ($iqn == null ? 43 : $iqn.hashCode());
        String $iscsiInterface = this.getIscsiInterface();
        result = result * 59 + ($iscsiInterface == null ? 43 : $iscsiInterface.hashCode());
        List<String> $portals = this.getPortals();
        result = result * 59 + ($portals == null ? 43 : ((Object)$portals).hashCode());
        SecretRef $secretRef = this.getSecretRef();
        result = result * 59 + ($secretRef == null ? 43 : ((Object)$secretRef).hashCode());
        String $targetPortal = this.getTargetPortal();
        result = result * 59 + ($targetPortal == null ? 43 : $targetPortal.hashCode());
        return result;
    }
}

