/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.Storageos;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.storageos.SecretRef;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.storageos.SecretRefBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.repo.volumes.storageos.SecretRefFluent;
import java.util.Objects;
import java.util.Optional;

public class StorageosFluent<A extends StorageosFluent<A>>
extends BaseFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private SecretRefBuilder secretRef;
    private String volumeName;
    private String volumeNamespace;

    public StorageosFluent() {
    }

    public StorageosFluent(Storageos instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Storageos instance) {
        Storageos storageos = instance = instance != null ? instance : new Storageos();
        if (instance != null) {
            this.withFsType(instance.getFsType());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
            this.withVolumeName(instance.getVolumeName());
            this.withVolumeNamespace(instance.getVolumeNamespace());
        }
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)((Object)this);
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)((Object)this);
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public SecretRef buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(SecretRef secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new SecretRefBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(SecretRef item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editStorageosSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new SecretRefBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(SecretRef item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)((Object)this);
    }

    public boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    public A withVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return (A)((Object)this);
    }

    public boolean hasVolumeNamespace() {
        return this.volumeNamespace != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageosFluent that = (StorageosFluent)((Object)o);
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        if (!Objects.equals((Object)this.secretRef, (Object)that.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.volumeName, that.volumeName)) {
            return false;
        }
        return Objects.equals(this.volumeNamespace, that.volumeNamespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef + ",");
        }
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName + ",");
        }
        if (this.volumeNamespace != null) {
            sb.append("volumeNamespace:");
            sb.append(this.volumeNamespace);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends SecretRefFluent<SecretRefNested<N>>
    implements Nested<N> {
        SecretRefBuilder builder;

        SecretRefNested(SecretRef item) {
            this.builder = new SecretRefBuilder(this, item);
        }

        public N and() {
            return (N)StorageosFluent.this.withSecretRef(this.builder.build());
        }

        public N endStorageosSecretRef() {
            return this.and();
        }
    }
}

