/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.resourceidentifiers;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.quarkiverse.argocd.v1beta1.argocdspec.resourceignoredifferences.resourceidentifiers.Customization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomizationFluent<A extends CustomizationFluent<A>>
extends BaseFluent<A> {
    private List<String> jqPathExpressions;
    private List<String> jsonPointers;
    private List<String> managedFieldsManagers;

    public CustomizationFluent() {
    }

    public CustomizationFluent(Customization instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Customization instance) {
        Customization customization = instance = instance != null ? instance : new Customization();
        if (instance != null) {
            this.withJqPathExpressions(instance.getJqPathExpressions());
            this.withJsonPointers(instance.getJsonPointers());
            this.withManagedFieldsManagers(instance.getManagedFieldsManagers());
        }
    }

    public A addToJqPathExpressions(int index, String item) {
        if (this.jqPathExpressions == null) {
            this.jqPathExpressions = new ArrayList<String>();
        }
        this.jqPathExpressions.add(index, item);
        return (A)((Object)this);
    }

    public A setToJqPathExpressions(int index, String item) {
        if (this.jqPathExpressions == null) {
            this.jqPathExpressions = new ArrayList<String>();
        }
        this.jqPathExpressions.set(index, item);
        return (A)((Object)this);
    }

    public A addToJqPathExpressions(String ... items) {
        if (this.jqPathExpressions == null) {
            this.jqPathExpressions = new ArrayList<String>();
        }
        for (String item : items) {
            this.jqPathExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToJqPathExpressions(Collection<String> items) {
        if (this.jqPathExpressions == null) {
            this.jqPathExpressions = new ArrayList<String>();
        }
        for (String item : items) {
            this.jqPathExpressions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromJqPathExpressions(String ... items) {
        if (this.jqPathExpressions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.jqPathExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJqPathExpressions(Collection<String> items) {
        if (this.jqPathExpressions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.jqPathExpressions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getJqPathExpressions() {
        return this.jqPathExpressions;
    }

    public String getJqPathExpression(int index) {
        return this.jqPathExpressions.get(index);
    }

    public String getFirstJqPathExpression() {
        return this.jqPathExpressions.get(0);
    }

    public String getLastJqPathExpression() {
        return this.jqPathExpressions.get(this.jqPathExpressions.size() - 1);
    }

    public String getMatchingJqPathExpression(Predicate<String> predicate) {
        for (String item : this.jqPathExpressions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingJqPathExpression(Predicate<String> predicate) {
        for (String item : this.jqPathExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJqPathExpressions(List<String> jqPathExpressions) {
        if (jqPathExpressions != null) {
            this.jqPathExpressions = new ArrayList<String>();
            for (String item : jqPathExpressions) {
                this.addToJqPathExpressions(item);
            }
        } else {
            this.jqPathExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withJqPathExpressions(String ... jqPathExpressions) {
        if (this.jqPathExpressions != null) {
            this.jqPathExpressions.clear();
            this._visitables.remove((Object)"jqPathExpressions");
        }
        if (jqPathExpressions != null) {
            for (String item : jqPathExpressions) {
                this.addToJqPathExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJqPathExpressions() {
        return this.jqPathExpressions != null && !this.jqPathExpressions.isEmpty();
    }

    public A addToJsonPointers(int index, String item) {
        if (this.jsonPointers == null) {
            this.jsonPointers = new ArrayList<String>();
        }
        this.jsonPointers.add(index, item);
        return (A)((Object)this);
    }

    public A setToJsonPointers(int index, String item) {
        if (this.jsonPointers == null) {
            this.jsonPointers = new ArrayList<String>();
        }
        this.jsonPointers.set(index, item);
        return (A)((Object)this);
    }

    public A addToJsonPointers(String ... items) {
        if (this.jsonPointers == null) {
            this.jsonPointers = new ArrayList<String>();
        }
        for (String item : items) {
            this.jsonPointers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToJsonPointers(Collection<String> items) {
        if (this.jsonPointers == null) {
            this.jsonPointers = new ArrayList<String>();
        }
        for (String item : items) {
            this.jsonPointers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromJsonPointers(String ... items) {
        if (this.jsonPointers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.jsonPointers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJsonPointers(Collection<String> items) {
        if (this.jsonPointers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.jsonPointers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getJsonPointers() {
        return this.jsonPointers;
    }

    public String getJsonPointer(int index) {
        return this.jsonPointers.get(index);
    }

    public String getFirstJsonPointer() {
        return this.jsonPointers.get(0);
    }

    public String getLastJsonPointer() {
        return this.jsonPointers.get(this.jsonPointers.size() - 1);
    }

    public String getMatchingJsonPointer(Predicate<String> predicate) {
        for (String item : this.jsonPointers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingJsonPointer(Predicate<String> predicate) {
        for (String item : this.jsonPointers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJsonPointers(List<String> jsonPointers) {
        if (jsonPointers != null) {
            this.jsonPointers = new ArrayList<String>();
            for (String item : jsonPointers) {
                this.addToJsonPointers(item);
            }
        } else {
            this.jsonPointers = null;
        }
        return (A)((Object)this);
    }

    public A withJsonPointers(String ... jsonPointers) {
        if (this.jsonPointers != null) {
            this.jsonPointers.clear();
            this._visitables.remove((Object)"jsonPointers");
        }
        if (jsonPointers != null) {
            for (String item : jsonPointers) {
                this.addToJsonPointers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJsonPointers() {
        return this.jsonPointers != null && !this.jsonPointers.isEmpty();
    }

    public A addToManagedFieldsManagers(int index, String item) {
        if (this.managedFieldsManagers == null) {
            this.managedFieldsManagers = new ArrayList<String>();
        }
        this.managedFieldsManagers.add(index, item);
        return (A)((Object)this);
    }

    public A setToManagedFieldsManagers(int index, String item) {
        if (this.managedFieldsManagers == null) {
            this.managedFieldsManagers = new ArrayList<String>();
        }
        this.managedFieldsManagers.set(index, item);
        return (A)((Object)this);
    }

    public A addToManagedFieldsManagers(String ... items) {
        if (this.managedFieldsManagers == null) {
            this.managedFieldsManagers = new ArrayList<String>();
        }
        for (String item : items) {
            this.managedFieldsManagers.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToManagedFieldsManagers(Collection<String> items) {
        if (this.managedFieldsManagers == null) {
            this.managedFieldsManagers = new ArrayList<String>();
        }
        for (String item : items) {
            this.managedFieldsManagers.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromManagedFieldsManagers(String ... items) {
        if (this.managedFieldsManagers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.managedFieldsManagers.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromManagedFieldsManagers(Collection<String> items) {
        if (this.managedFieldsManagers == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.managedFieldsManagers.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getManagedFieldsManagers() {
        return this.managedFieldsManagers;
    }

    public String getManagedFieldsManager(int index) {
        return this.managedFieldsManagers.get(index);
    }

    public String getFirstManagedFieldsManager() {
        return this.managedFieldsManagers.get(0);
    }

    public String getLastManagedFieldsManager() {
        return this.managedFieldsManagers.get(this.managedFieldsManagers.size() - 1);
    }

    public String getMatchingManagedFieldsManager(Predicate<String> predicate) {
        for (String item : this.managedFieldsManagers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingManagedFieldsManager(Predicate<String> predicate) {
        for (String item : this.managedFieldsManagers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withManagedFieldsManagers(List<String> managedFieldsManagers) {
        if (managedFieldsManagers != null) {
            this.managedFieldsManagers = new ArrayList<String>();
            for (String item : managedFieldsManagers) {
                this.addToManagedFieldsManagers(item);
            }
        } else {
            this.managedFieldsManagers = null;
        }
        return (A)((Object)this);
    }

    public A withManagedFieldsManagers(String ... managedFieldsManagers) {
        if (this.managedFieldsManagers != null) {
            this.managedFieldsManagers.clear();
            this._visitables.remove((Object)"managedFieldsManagers");
        }
        if (managedFieldsManagers != null) {
            for (String item : managedFieldsManagers) {
                this.addToManagedFieldsManagers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasManagedFieldsManagers() {
        return this.managedFieldsManagers != null && !this.managedFieldsManagers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomizationFluent that = (CustomizationFluent)((Object)o);
        if (!Objects.equals(this.jqPathExpressions, that.jqPathExpressions)) {
            return false;
        }
        if (!Objects.equals(this.jsonPointers, that.jsonPointers)) {
            return false;
        }
        return Objects.equals(this.managedFieldsManagers, that.managedFieldsManagers);
    }

    public int hashCode() {
        return Objects.hash(this.jqPathExpressions, this.jsonPointers, this.managedFieldsManagers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jqPathExpressions != null && !this.jqPathExpressions.isEmpty()) {
            sb.append("jqPathExpressions:");
            sb.append(this.jqPathExpressions + ",");
        }
        if (this.jsonPointers != null && !this.jsonPointers.isEmpty()) {
            sb.append("jsonPointers:");
            sb.append(this.jsonPointers + ",");
        }
        if (this.managedFieldsManagers != null && !this.managedFieldsManagers.isEmpty()) {
            sb.append("managedFieldsManagers:");
            sb.append(this.managedFieldsManagers);
        }
        sb.append("}");
        return sb.toString();
    }
}

