/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.server;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Autoscale;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.Hpa;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.HpaBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.HpaFluent;
import java.util.Objects;
import java.util.Optional;

public class AutoscaleFluent<A extends AutoscaleFluent<A>>
extends BaseFluent<A> {
    private Boolean enabled;
    private HpaBuilder hpa;

    public AutoscaleFluent() {
    }

    public AutoscaleFluent(Autoscale instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Autoscale instance) {
        Autoscale autoscale = instance = instance != null ? instance : new Autoscale();
        if (instance != null) {
            this.withEnabled(instance.getEnabled());
            this.withHpa(instance.getHpa());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Hpa buildHpa() {
        return this.hpa != null ? this.hpa.build() : null;
    }

    public A withHpa(Hpa hpa) {
        this._visitables.remove((Object)"hpa");
        if (hpa != null) {
            this.hpa = new HpaBuilder(hpa);
            this._visitables.get((Object)"hpa").add(this.hpa);
        } else {
            this.hpa = null;
            this._visitables.get((Object)"hpa").remove((Object)this.hpa);
        }
        return (A)((Object)this);
    }

    public boolean hasHpa() {
        return this.hpa != null;
    }

    public HpaNested<A> withNewHpa() {
        return new HpaNested(null);
    }

    public HpaNested<A> withNewHpaLike(Hpa item) {
        return new HpaNested(item);
    }

    public HpaNested<A> editHpa() {
        return this.withNewHpaLike(Optional.ofNullable(this.buildHpa()).orElse(null));
    }

    public HpaNested<A> editOrNewHpa() {
        return this.withNewHpaLike(Optional.ofNullable(this.buildHpa()).orElse(new HpaBuilder().build()));
    }

    public HpaNested<A> editOrNewHpaLike(Hpa item) {
        return this.withNewHpaLike(Optional.ofNullable(this.buildHpa()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AutoscaleFluent that = (AutoscaleFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals((Object)this.hpa, (Object)that.hpa);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.hpa, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.hpa != null) {
            sb.append("hpa:");
            sb.append((Object)this.hpa);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class HpaNested<N>
    extends HpaFluent<HpaNested<N>>
    implements Nested<N> {
        HpaBuilder builder;

        HpaNested(Hpa item) {
            this.builder = new HpaBuilder(this, item);
        }

        public N and() {
            return (N)AutoscaleFluent.this.withHpa(this.builder.build());
        }

        public N endHpa() {
            return this.and();
        }
    }
}

