/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.server;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Grpc;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.grpc.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.grpc.IngressBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.grpc.IngressFluent;
import java.util.Objects;
import java.util.Optional;

public class GrpcFluent<A extends GrpcFluent<A>>
extends BaseFluent<A> {
    private String host;
    private IngressBuilder ingress;

    public GrpcFluent() {
    }

    public GrpcFluent(Grpc instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Grpc instance) {
        Grpc grpc = instance = instance != null ? instance : new Grpc();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withIngress(instance.getIngress());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public Ingress buildIngress() {
        return this.ingress != null ? this.ingress.build() : null;
    }

    public A withIngress(Ingress ingress) {
        this._visitables.remove((Object)"ingress");
        if (ingress != null) {
            this.ingress = new IngressBuilder(ingress);
            this._visitables.get((Object)"ingress").add(this.ingress);
        } else {
            this.ingress = null;
            this._visitables.get((Object)"ingress").remove((Object)this.ingress);
        }
        return (A)((Object)this);
    }

    public boolean hasIngress() {
        return this.ingress != null;
    }

    public IngressNested<A> withNewIngress() {
        return new IngressNested(null);
    }

    public IngressNested<A> withNewIngressLike(Ingress item) {
        return new IngressNested(item);
    }

    public IngressNested<A> editGrpcIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(null));
    }

    public IngressNested<A> editOrNewIngress() {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(new IngressBuilder().build()));
    }

    public IngressNested<A> editOrNewIngressLike(Ingress item) {
        return this.withNewIngressLike(Optional.ofNullable(this.buildIngress()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GrpcFluent that = (GrpcFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        return Objects.equals((Object)this.ingress, (Object)that.ingress);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.ingress, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append((Object)this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    public class IngressNested<N>
    extends IngressFluent<IngressNested<N>>
    implements Nested<N> {
        IngressBuilder builder;

        IngressNested(Ingress item) {
            this.builder = new IngressBuilder(this, item);
        }

        public N and() {
            return (N)GrpcFluent.this.withIngress(this.builder.build());
        }

        public N endGrpcIngress() {
            return this.and();
        }
    }
}

