/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.server;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.Ingress;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ingress.Tls;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ingress.TlsBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.ingress.TlsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressFluent<A extends IngressFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private Boolean enabled;
    private String ingressClassName;
    private String path;
    private ArrayList<TlsBuilder> tls;

    public IngressFluent() {
    }

    public IngressFluent(Ingress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Ingress instance) {
        Ingress ingress = instance = instance != null ? instance : new Ingress();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withEnabled(instance.getEnabled());
            this.withIngressClassName(instance.getIngressClassName());
            this.withPath(instance.getPath());
            this.withTls(instance.getTls());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getIngressClassName() {
        return this.ingressClassName;
    }

    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)((Object)this);
    }

    public boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public A addToTls(int index, Tls item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        TlsBuilder builder = new TlsBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").add(index, builder);
            this.tls.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTls(int index, Tls item) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        TlsBuilder builder = new TlsBuilder(item);
        if (index < 0 || index >= this.tls.size()) {
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        } else {
            this._visitables.get((Object)"tls").set(index, builder);
            this.tls.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTls(Tls ... items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (Tls item : items) {
            TlsBuilder builder = new TlsBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIngressTls(Collection<Tls> items) {
        if (this.tls == null) {
            this.tls = new ArrayList();
        }
        for (Tls item : items) {
            TlsBuilder builder = new TlsBuilder(item);
            this._visitables.get((Object)"tls").add(builder);
            this.tls.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTls(Tls ... items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (Tls item : items) {
            TlsBuilder builder = new TlsBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIngressTls(Collection<Tls> items) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        for (Tls item : items) {
            TlsBuilder builder = new TlsBuilder(item);
            this._visitables.get((Object)"tls").remove((Object)builder);
            this.tls.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIngressTls(Predicate<TlsBuilder> predicate) {
        if (this.tls == null) {
            return (A)((Object)this);
        }
        Iterator<TlsBuilder> each = this.tls.iterator();
        List visitables = this._visitables.get((Object)"tls");
        while (each.hasNext()) {
            TlsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Tls> buildTls() {
        return this.tls != null ? IngressFluent.build(this.tls) : null;
    }

    public Tls buildTl(int index) {
        return this.tls.get(index).build();
    }

    public Tls buildFirstTl() {
        return this.tls.get(0).build();
    }

    public Tls buildLastTl() {
        return this.tls.get(this.tls.size() - 1).build();
    }

    public Tls buildMatchingTl(Predicate<TlsBuilder> predicate) {
        for (TlsBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTl(Predicate<TlsBuilder> predicate) {
        for (TlsBuilder item : this.tls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTls(List<Tls> tls) {
        if (this.tls != null) {
            this._visitables.get((Object)"tls").clear();
        }
        if (tls != null) {
            this.tls = new ArrayList();
            for (Tls item : tls) {
                this.addToTls(item);
            }
        } else {
            this.tls = null;
        }
        return (A)((Object)this);
    }

    public A withTls(Tls ... tls) {
        if (this.tls != null) {
            this.tls.clear();
            this._visitables.remove((Object)"tls");
        }
        if (tls != null) {
            for (Tls item : tls) {
                this.addToTls(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTls() {
        return this.tls != null && !this.tls.isEmpty();
    }

    public TlsNested<A> addNewTl() {
        return new TlsNested(-1, null);
    }

    public TlsNested<A> addNewTlLike(Tls item) {
        return new TlsNested(-1, item);
    }

    public TlsNested<A> setNewTlLike(int index, Tls item) {
        return new TlsNested(index, item);
    }

    public TlsNested<A> editTl(int index) {
        if (this.tls.size() <= index) {
            throw new RuntimeException("Can't edit tls. Index exceeds size.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editFirstTl() {
        if (this.tls.size() == 0) {
            throw new RuntimeException("Can't edit first tls. The list is empty.");
        }
        return this.setNewTlLike(0, this.buildTl(0));
    }

    public TlsNested<A> editLastTl() {
        int index = this.tls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tls. The list is empty.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public TlsNested<A> editMatchingTl(Predicate<TlsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tls.size(); ++i) {
            if (!predicate.test(this.tls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tls. No match found.");
        }
        return this.setNewTlLike(index, this.buildTl(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressFluent that = (IngressFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.ingressClassName, that.ingressClassName)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.tls, that.tls);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.enabled, this.ingressClassName, this.path, this.tls, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.tls != null && !this.tls.isEmpty()) {
            sb.append("tls:");
            sb.append(this.tls);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class TlsNested<N>
    extends TlsFluent<TlsNested<N>>
    implements Nested<N> {
        TlsBuilder builder;
        int index;

        TlsNested(int index, Tls item) {
            this.index = index;
            this.builder = new TlsBuilder(this, item);
        }

        public N and() {
            return (N)IngressFluent.this.setToTls(this.index, this.builder.build());
        }

        public N endIngressTl() {
            return this.and();
        }
    }
}

