/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.HpaBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.hpa.ScaleTargetRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"maxReplicas", "minReplicas", "scaleTargetRef", "targetCPUUtilizationPercentage"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Hpa
implements Editable<HpaBuilder>,
KubernetesResource {
    @JsonProperty(value="maxReplicas")
    @Required
    @JsonPropertyDescription(value="maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer maxReplicas;
    @JsonProperty(value="minReplicas")
    @JsonPropertyDescription(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer minReplicas;
    @JsonProperty(value="scaleTargetRef")
    @Required
    @JsonPropertyDescription(value="reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ScaleTargetRef scaleTargetRef;
    @JsonProperty(value="targetCPUUtilizationPercentage")
    @JsonPropertyDescription(value="targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer targetCPUUtilizationPercentage;

    public HpaBuilder edit() {
        return new HpaBuilder(this);
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public ScaleTargetRef getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(ScaleTargetRef scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public void setTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
    }

    public String toString() {
        return "Hpa(maxReplicas=" + this.getMaxReplicas() + ", minReplicas=" + this.getMinReplicas() + ", scaleTargetRef=" + this.getScaleTargetRef() + ", targetCPUUtilizationPercentage=" + this.getTargetCPUUtilizationPercentage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hpa)) {
            return false;
        }
        Hpa other = (Hpa)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxReplicas = this.getMaxReplicas();
        Integer other$maxReplicas = other.getMaxReplicas();
        if (this$maxReplicas == null ? other$maxReplicas != null : !((Object)this$maxReplicas).equals(other$maxReplicas)) {
            return false;
        }
        Integer this$minReplicas = this.getMinReplicas();
        Integer other$minReplicas = other.getMinReplicas();
        if (this$minReplicas == null ? other$minReplicas != null : !((Object)this$minReplicas).equals(other$minReplicas)) {
            return false;
        }
        Integer this$targetCPUUtilizationPercentage = this.getTargetCPUUtilizationPercentage();
        Integer other$targetCPUUtilizationPercentage = other.getTargetCPUUtilizationPercentage();
        if (this$targetCPUUtilizationPercentage == null ? other$targetCPUUtilizationPercentage != null : !((Object)this$targetCPUUtilizationPercentage).equals(other$targetCPUUtilizationPercentage)) {
            return false;
        }
        ScaleTargetRef this$scaleTargetRef = this.getScaleTargetRef();
        ScaleTargetRef other$scaleTargetRef = other.getScaleTargetRef();
        return !(this$scaleTargetRef == null ? other$scaleTargetRef != null : !((Object)this$scaleTargetRef).equals(other$scaleTargetRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Hpa;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxReplicas = this.getMaxReplicas();
        result = result * 59 + ($maxReplicas == null ? 43 : ((Object)$maxReplicas).hashCode());
        Integer $minReplicas = this.getMinReplicas();
        result = result * 59 + ($minReplicas == null ? 43 : ((Object)$minReplicas).hashCode());
        Integer $targetCPUUtilizationPercentage = this.getTargetCPUUtilizationPercentage();
        result = result * 59 + ($targetCPUUtilizationPercentage == null ? 43 : ((Object)$targetCPUUtilizationPercentage).hashCode());
        ScaleTargetRef $scaleTargetRef = this.getScaleTargetRef();
        result = result * 59 + ($scaleTargetRef == null ? 43 : ((Object)$scaleTargetRef).hashCode());
        return result;
    }
}

