/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.Hpa;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.hpa.ScaleTargetRef;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.hpa.ScaleTargetRefBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.server.autoscale.hpa.ScaleTargetRefFluent;
import java.util.Objects;
import java.util.Optional;

public class HpaFluent<A extends HpaFluent<A>>
extends BaseFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private ScaleTargetRefBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;

    public HpaFluent() {
    }

    public HpaFluent(Hpa instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Hpa instance) {
        Hpa hpa = instance = instance != null ? instance : new Hpa();
        if (instance != null) {
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        }
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)((Object)this);
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)((Object)this);
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public ScaleTargetRef buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(ScaleTargetRef scaleTargetRef) {
        this._visitables.remove((Object)"scaleTargetRef");
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new ScaleTargetRefBuilder(scaleTargetRef);
            this._visitables.get((Object)"scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get((Object)"scaleTargetRef").remove((Object)this.scaleTargetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(ScaleTargetRef item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new ScaleTargetRefBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(ScaleTargetRef item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return (A)((Object)this);
    }

    public boolean hasTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HpaFluent that = (HpaFluent)((Object)o);
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals((Object)this.scaleTargetRef, (Object)that.scaleTargetRef)) {
            return false;
        }
        return Objects.equals(this.targetCPUUtilizationPercentage, that.targetCPUUtilizationPercentage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.targetCPUUtilizationPercentage, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef + ",");
        }
        if (this.targetCPUUtilizationPercentage != null) {
            sb.append("targetCPUUtilizationPercentage:");
            sb.append(this.targetCPUUtilizationPercentage);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends ScaleTargetRefFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        ScaleTargetRefBuilder builder;

        ScaleTargetRefNested(ScaleTargetRef item) {
            this.builder = new ScaleTargetRefBuilder(this, item);
        }

        public N and() {
            return (N)HpaFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

