/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.sso;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.KeycloakBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.keycloak.Resources;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"host", "image", "resources", "rootCA", "verifyTLS", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Keycloak
implements Editable<KeycloakBuilder>,
KubernetesResource {
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="Host is the hostname to use for Ingress/Route resources.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="Image is the Keycloak container image.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="resources")
    @JsonPropertyDescription(value="Resources defines the Compute Resources required by the container for Keycloak.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Resources resources;
    @JsonProperty(value="rootCA")
    @JsonPropertyDescription(value="Custom root CA certificate for communicating with the Keycloak OIDC provider")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rootCA;
    @JsonProperty(value="verifyTLS")
    @JsonPropertyDescription(value="VerifyTLS set to false disables strict TLS validation.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean verifyTLS;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version is the Keycloak container image tag.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public KeycloakBuilder edit() {
        return new KeycloakBuilder(this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public Resources getResources() {
        return this.resources;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public String getRootCA() {
        return this.rootCA;
    }

    public void setRootCA(String rootCA) {
        this.rootCA = rootCA;
    }

    public Boolean getVerifyTLS() {
        return this.verifyTLS;
    }

    public void setVerifyTLS(Boolean verifyTLS) {
        this.verifyTLS = verifyTLS;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "Keycloak(host=" + this.getHost() + ", image=" + this.getImage() + ", resources=" + this.getResources() + ", rootCA=" + this.getRootCA() + ", verifyTLS=" + this.getVerifyTLS() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Keycloak)) {
            return false;
        }
        Keycloak other = (Keycloak)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$verifyTLS = this.getVerifyTLS();
        Boolean other$verifyTLS = other.getVerifyTLS();
        if (this$verifyTLS == null ? other$verifyTLS != null : !((Object)this$verifyTLS).equals(other$verifyTLS)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$rootCA = this.getRootCA();
        String other$rootCA = other.getRootCA();
        if (this$rootCA == null ? other$rootCA != null : !this$rootCA.equals(other$rootCA)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Keycloak;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $verifyTLS = this.getVerifyTLS();
        result = result * 59 + ($verifyTLS == null ? 43 : ((Object)$verifyTLS).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $rootCA = this.getRootCA();
        result = result * 59 + ($rootCA == null ? 43 : $rootCA.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

