/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.argocd.v1beta1.argocdspec.sso;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.Keycloak;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.keycloak.Resources;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.keycloak.ResourcesBuilder;
import io.quarkiverse.argocd.v1beta1.argocdspec.sso.keycloak.ResourcesFluent;
import java.util.Objects;
import java.util.Optional;

public class KeycloakFluent<A extends KeycloakFluent<A>>
extends BaseFluent<A> {
    private String host;
    private String image;
    private ResourcesBuilder resources;
    private String rootCA;
    private Boolean verifyTLS;
    private String version;

    public KeycloakFluent() {
    }

    public KeycloakFluent(Keycloak instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Keycloak instance) {
        Keycloak keycloak = instance = instance != null ? instance : new Keycloak();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withImage(instance.getImage());
            this.withResources(instance.getResources());
            this.withRootCA(instance.getRootCA());
            this.withVerifyTLS(instance.getVerifyTLS());
            this.withVersion(instance.getVersion());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Resources buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(Resources resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourcesBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(Resources item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editKeycloakResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourcesBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(Resources item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getRootCA() {
        return this.rootCA;
    }

    public A withRootCA(String rootCA) {
        this.rootCA = rootCA;
        return (A)((Object)this);
    }

    public boolean hasRootCA() {
        return this.rootCA != null;
    }

    public Boolean getVerifyTLS() {
        return this.verifyTLS;
    }

    public A withVerifyTLS(Boolean verifyTLS) {
        this.verifyTLS = verifyTLS;
        return (A)((Object)this);
    }

    public boolean hasVerifyTLS() {
        return this.verifyTLS != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeycloakFluent that = (KeycloakFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.rootCA, that.rootCA)) {
            return false;
        }
        if (!Objects.equals(this.verifyTLS, that.verifyTLS)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.image, this.resources, this.rootCA, this.verifyTLS, this.version, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.rootCA != null) {
            sb.append("rootCA:");
            sb.append(this.rootCA + ",");
        }
        if (this.verifyTLS != null) {
            sb.append("verifyTLS:");
            sb.append(this.verifyTLS + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withVerifyTLS() {
        return this.withVerifyTLS(true);
    }

    public class ResourcesNested<N>
    extends ResourcesFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourcesBuilder builder;

        ResourcesNested(Resources item) {
            this.builder = new ResourcesBuilder(this, item);
        }

        public N and() {
            return (N)KeycloakFluent.this.withResources(this.builder.build());
        }

        public N endKeycloakResources() {
            return this.and();
        }
    }
}

