/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.azure.core.deployment;

import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.DateTimeRfc1123;
import io.netty.handler.ssl.OpenSsl;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.jandex.DotName;

public class AzureCoreSupportProcessor {
    private static final DotName SERVICE_INTERFACE_DOT_NAME = DotName.createSimple((String)ServiceInterface.class.getName());

    @BuildStep
    IndexDependencyBuildItem indexDependency() {
        return new IndexDependencyBuildItem("com.azure", "azure-core");
    }

    @BuildStep
    void runtimeInitializedClasses(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClasses) {
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem(OpenSsl.class.getName()));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.internal.tcnative.SSL"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("io.netty.util.concurrent.GlobalEventExecutor"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.azure.core.http.vertx.VertxAsyncHttpClientProvider$GlobalVertxHttpClient"));
        runtimeInitializedClasses.produce((BuildItem)new RuntimeInitializedClassBuildItem("com.azure.core.http.vertx.VertxAsyncHttpClientBuilder$DefaultVertx"));
    }

    @BuildStep
    void reflectiveClasses(BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{DateTimeRfc1123.class, StreamResponse.class, ResponseBase.class, HttpHeaderName.class}).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.microsoft.aad.msal4j.AadInstanceDiscoveryResponse", "com.microsoft.aad.msal4j.InstanceDiscoveryMetadataEntry"}).fields().build());
    }

    @BuildStep
    void nativeResources(BuildProducer<ServiceProviderBuildItem> services, BuildProducer<NativeImageResourceBuildItem> nativeResources) {
        Stream.of(HttpClientProvider.class.getName(), "reactor.blockhound.integration.BlockHoundIntegration").forEach(service -> {
            try {
                Set implementations = ServiceUtil.classNamesNamedIn((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)("META-INF/services/" + service));
                services.produce((BuildItem)new ServiceProviderBuildItem(service, implementations.toArray(new String[0])));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"azure-core.properties"}));
    }

    @BuildStep
    void proxyDefinitions(CombinedIndexBuildItem combinedIndex, BuildProducer<NativeImageProxyDefinitionBuildItem> proxyDefinitions) {
        combinedIndex.getIndex().getAnnotations(SERVICE_INTERFACE_DOT_NAME).stream().map(annotationInstance -> annotationInstance.target().asClass().name().toString()).map(xva$0 -> new NativeImageProxyDefinitionBuildItem(new String[]{xva$0})).forEach(arg_0 -> proxyDefinitions.produce(arg_0));
    }
}

