/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dashbuilder.runtime;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;

public class SampleEditHandler
implements Handler<RoutingContext> {
    private final String SAMPLE_ID_PARAM = "sampleId";
    private final String USER_SAMPLES_PATH = "src/main/resources/dashboards";
    private final String USER_SAMPLE_EXT = ".dash.yaml";
    private static final Logger log = Logger.getLogger(SampleEditHandler.class);
    private Map<String, String> samples;
    private String appDir;

    public SampleEditHandler() {
    }

    public SampleEditHandler(String appDir, Map<String, String> samples) {
        this.appDir = appDir;
        this.samples = samples;
    }

    public void handle(RoutingContext event) {
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        if (request.method() != HttpMethod.GET) {
            response.setStatusCode(405);
            response.end();
            return;
        }
        String sampleId = request.getParam("sampleId");
        if (sampleId != null && this.samples.containsKey(sampleId)) {
            Optional<String> samplePathOp = this.storeOrGetExistingSample(sampleId);
            if (samplePathOp.isPresent()) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
                response.setStatusCode(200);
                response.end(samplePathOp.get());
            } else {
                response.setStatusCode(500);
                response.end();
            }
        } else {
            response.setStatusCode(404);
            response.end();
        }
    }

    private Optional<String> storeOrGetExistingSample(String sampleId) {
        Path dir = Paths.get(this.appDir, "src/main/resources/dashboards", sampleId + ".dash.yaml");
        if (!dir.toFile().exists()) {
            try {
                Files.createDirectories(dir.getParent(), new FileAttribute[0]);
                Files.writeString(dir, (CharSequence)this.samples.get(sampleId), new OpenOption[0]);
            }
            catch (IOException e) {
                log.warn((Object)"Not able to create user sample dashboard.", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.of(dir.toAbsolutePath().toString());
    }
}

