/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.deployment;

import io.quarkiverse.githubaction.Action;
import io.quarkiverse.githubaction.Context;
import io.quarkiverse.githubaction.deployment.DispatchingConfiguration;
import io.quarkiverse.githubaction.deployment.EventDefinition;
import io.quarkiverse.githubaction.deployment.GitHubActionDotNames;
import io.quarkiverse.githubaction.deployment.VetoUserDefinedEventListeningClassesAnnotationsTransformer;
import io.quarkiverse.githubaction.runtime.ConfigFileReader;
import io.quarkiverse.githubaction.runtime.GitHubEvent;
import io.quarkiverse.githubaction.runtime.GitHubEventHandler;
import io.quarkiverse.githubaction.runtime.Multiplexer;
import io.quarkiverse.githubaction.runtime.PayloadTypeResolver;
import io.quarkiverse.githubapi.deployment.GitHubApiClassWithBridgeMethodsBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class GitHubActionProcessor {
    private static final Logger LOG = Logger.getLogger(GitHubActionProcessor.class);
    private static final String FEATURE = "github-action";
    private static final String EVENT_EMITTER_FIELD = "eventEmitter";
    private static final MethodDescriptor GITHUB_EVENT_GET_NAME = MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getName", String.class, (Class[])new Class[0]);
    private static final MethodDescriptor GITHUB_EVENT_GET_EVENT = MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getEvent", String.class, (Class[])new Class[0]);
    private static final MethodDescriptor GITHUB_EVENT_GET_EVENT_ACTION = MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getEventAction", String.class, (Class[])new Class[0]);
    private static final MethodDescriptor EVENT_SELECT = MethodDescriptor.ofMethod(Event.class, (String)"select", Event.class, (Class[])new Class[]{Annotation[].class});
    private static final MethodDescriptor EVENT_FIRE = MethodDescriptor.ofMethod(Event.class, (String)"fire", Void.TYPE, (Class[])new Class[]{Object.class});

    GitHubActionProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void silentStartup(BuildProducer<RunTimeConfigurationDefaultBuildItem> configurationDefaults) {
        configurationDefaults.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.log.level", "WARNING"));
        configurationDefaults.produce((BuildItem)new RunTimeConfigurationDefaultBuildItem("quarkus.banner.enabled", "false"));
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        for (AnnotationInstance configFileAnnotationInstance : combinedIndex.getIndex().getAnnotations(GitHubActionDotNames.CONFIG_FILE)) {
            MethodParameterInfo methodParameter = configFileAnnotationInstance.target().asMethodParameter();
            short parameterPosition = methodParameter.position();
            org.jboss.jandex.Type parameterType = (org.jboss.jandex.Type)methodParameter.method().parameterTypes().get(parameterPosition);
            reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(combinedIndex.getIndex()).source(GitHubActionProcessor.class.getSimpleName() + " > " + methodParameter.method().declaringClass() + "#" + methodParameter.method()).build());
        }
    }

    @BuildStep
    void removeCompatibilityBridgeMethodsFromGitHubApi(BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformers, List<GitHubApiClassWithBridgeMethodsBuildItem> gitHubApiClassesWithBridgeMethods) {
        for (GitHubApiClassWithBridgeMethodsBuildItem gitHubApiClassWithBridgeMethods : gitHubApiClassesWithBridgeMethods) {
            bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform(gitHubApiClassWithBridgeMethods.getClassName()).setVisitorFunction((ignored, visitor) -> new RemoveBridgeMethodsClassVisitor((ClassVisitor)visitor, gitHubApiClassWithBridgeMethods.getClassName(), gitHubApiClassWithBridgeMethods.getMethodsWithBridges())).build());
        }
    }

    @BuildStep
    void generateClasses(CombinedIndexBuildItem combinedIndex, LaunchModeBuildItem launchMode, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        Collection<EventDefinition> allEventDefinitions = GitHubActionProcessor.getAllEventDefinitions(combinedIndex.getIndex());
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new VetoUserDefinedEventListeningClassesAnnotationsTransformer(allEventDefinitions.stream().map(d -> d.getAnnotation()).collect(Collectors.toSet()))));
        String[] subscriberAnnotations = (String[])allEventDefinitions.stream().map(d -> d.getAnnotation().toString()).toArray(String[]::new);
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(subscriberAnnotations));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{Action.class}));
        DispatchingConfiguration dispatchingConfiguration = GitHubActionProcessor.getDispatchingConfiguration(combinedIndex.getIndex(), allEventDefinitions);
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GitHubActionProcessor.generateAnnotationLiterals((ClassOutput)classOutput, dispatchingConfiguration);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GitHubActionProcessor.generatePayloadTypeResolver((ClassOutput)beanClassOutput, reflectiveClasses, allEventDefinitions);
        GitHubActionProcessor.generateActionMain((ClassOutput)beanClassOutput, combinedIndex, launchMode, dispatchingConfiguration, reflectiveClasses);
        GitHubActionProcessor.generateMultiplexers((ClassOutput)beanClassOutput, dispatchingConfiguration, reflectiveClasses);
    }

    private static Collection<EventDefinition> getAllEventDefinitions(IndexView index) {
        ArrayList<EventDefinition> mainEventDefinitions = new ArrayList<EventDefinition>();
        ArrayList<EventDefinition> allEventDefinitions = new ArrayList<EventDefinition>();
        for (AnnotationInstance eventInstance : index.getAnnotations(GitHubActionDotNames.EVENT)) {
            if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            mainEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), eventInstance.value("name").asString(), null, eventInstance.value("payload").asClass().name()));
        }
        allEventDefinitions.addAll(mainEventDefinitions);
        for (EventDefinition mainEventDefinition : mainEventDefinitions) {
            for (AnnotationInstance eventInstance : index.getAnnotations(mainEventDefinition.getAnnotation())) {
                if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                AnnotationValue actionValue = eventInstance.value();
                allEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), mainEventDefinition.getEvent(), actionValue != null ? actionValue.asString() : null, mainEventDefinition.getPayloadType()));
            }
        }
        return allEventDefinitions;
    }

    private static DispatchingConfiguration getDispatchingConfiguration(IndexView index, Collection<EventDefinition> allEventDefinitions) {
        DispatchingConfiguration configuration = new DispatchingConfiguration();
        Collection actionInstances = index.getAnnotations(GitHubActionDotNames.ACTION).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
        for (AnnotationInstance actionInstance : actionInstances) {
            String name = actionInstance.valueWithDefault(index).asString();
            MethodInfo methodInfo = actionInstance.target().asMethod();
            boolean hasEventListeners = false;
            for (EventDefinition eventDefinition : allEventDefinitions) {
                List eventSubscriberInstances = methodInfo.annotations(eventDefinition.getAnnotation());
                for (AnnotationInstance eventSubscriberInstance : eventSubscriberInstances) {
                    String action = eventDefinition.getAction() != null ? eventDefinition.getAction() : (eventSubscriberInstance.value() != null ? eventSubscriberInstance.value().asString() : "*");
                    MethodParameterInfo annotatedParameter = eventSubscriberInstance.target().asMethodParameter();
                    DotName annotatedParameterType = ((org.jboss.jandex.Type)annotatedParameter.method().parameterTypes().get(annotatedParameter.position())).name();
                    if (!eventDefinition.getPayloadType().equals((Object)annotatedParameterType)) {
                        throw new IllegalStateException("Parameter subscribing to a GitHub '" + eventDefinition.getEvent() + "' event should be of type '" + eventDefinition.getPayloadType() + "'. Offending method: " + methodInfo.declaringClass().name() + "#" + methodInfo);
                    }
                    configuration.getOrCreateActionConfiguration(name, eventDefinition.getEvent(), eventDefinition.getPayloadType().toString()).addEventAnnotation(action, eventSubscriberInstance, eventSubscriberInstance.valuesWithDefaults(index));
                    configuration.addActionDispatchingMethod(new DispatchingConfiguration.ActionDispatchingMethod(name, eventSubscriberInstance, methodInfo));
                    hasEventListeners = true;
                }
            }
            if (hasEventListeners) continue;
            configuration.getOrCreateActionConfiguration(name, "<<ALL>>", null);
            configuration.addActionDispatchingMethod(new DispatchingConfiguration.ActionDispatchingMethod(name, null, methodInfo));
        }
        for (EventDefinition eventDefinition : allEventDefinitions) {
            Collection eventSubscriberInstances = index.getAnnotations(eventDefinition.getAnnotation()).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(ai -> !ai.target().asMethodParameter().method().hasAnnotation(GitHubActionDotNames.ACTION)).collect(Collectors.toList());
            for (AnnotationInstance eventSubscriberInstance : eventSubscriberInstances) {
                MethodParameterInfo annotatedParameter = eventSubscriberInstance.target().asMethodParameter();
                MethodInfo methodInfo = annotatedParameter.method();
                String name = "<<UNNAMED>>";
                String action = eventDefinition.getAction() != null ? eventDefinition.getAction() : (eventSubscriberInstance.value() != null ? eventSubscriberInstance.value().asString() : "*");
                DotName annotatedParameterType = ((org.jboss.jandex.Type)annotatedParameter.method().parameterTypes().get(annotatedParameter.position())).name();
                if (!eventDefinition.getPayloadType().equals((Object)annotatedParameterType)) {
                    throw new IllegalStateException("Parameter subscribing to a GitHub '" + eventDefinition.getEvent() + "' action should be of type '" + eventDefinition.getPayloadType() + "'. Offending method: " + methodInfo.declaringClass().name() + "#" + methodInfo);
                }
                configuration.getOrCreateActionConfiguration(name, eventDefinition.getEvent(), eventDefinition.getPayloadType().toString()).addEventAnnotation(action, eventSubscriberInstance, eventSubscriberInstance.valuesWithDefaults(index));
                configuration.addActionDispatchingMethod(new DispatchingConfiguration.ActionDispatchingMethod(name, eventSubscriberInstance, methodInfo));
            }
        }
        return configuration;
    }

    private static void generateAnnotationLiterals(ClassOutput classOutput, DispatchingConfiguration dispatchingConfiguration) {
        for (DispatchingConfiguration.ActionDispatchingConfiguration eventDispatchingConfiguration : dispatchingConfiguration.getActionDispatchingConfigurations()) {
            for (DispatchingConfiguration.EventAnnotationLiteral eventAnnotationLiteral : eventDispatchingConfiguration.getEventAnnotationLiterals()) {
                String literalClassName = GitHubActionProcessor.getLiteralClassName(eventAnnotationLiteral.getName());
                String signature = String.format("L%1$s<L%2$s;>;L%2$s;", AnnotationLiteral.class.getName().replace('.', '/'), eventAnnotationLiteral.getName().toString().replace('.', '/'));
                ClassCreator literalClassCreator = ClassCreator.builder().classOutput(classOutput).className(literalClassName).signature(signature).superClass(AnnotationLiteral.class).interfaces(new String[]{eventAnnotationLiteral.getName().toString()}).build();
                Object[] parameterTypes = new Class[eventAnnotationLiteral.getAttributes().size()];
                Arrays.fill(parameterTypes, String.class);
                MethodCreator constructorCreator = literalClassCreator.getMethodCreator("<init>", (Object)"V", parameterTypes);
                constructorCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructorCreator.getThis(), new ResultHandle[0]);
                for (int i = 0; i < eventAnnotationLiteral.getAttributes().size(); ++i) {
                    constructorCreator.writeInstanceField(FieldDescriptor.of((String)literalClassName, (String)eventAnnotationLiteral.getAttributes().get(i), String.class), constructorCreator.getThis(), constructorCreator.getMethodParam(i));
                    constructorCreator.setModifiers(1);
                }
                constructorCreator.returnValue(null);
                for (String attribute : eventAnnotationLiteral.getAttributes()) {
                    literalClassCreator.getFieldCreator(attribute, String.class).setModifiers(2);
                    MethodCreator getterCreator = literalClassCreator.getMethodCreator(attribute, String.class, new Class[0]);
                    getterCreator.setModifiers(1);
                    getterCreator.returnValue(getterCreator.readInstanceField(FieldDescriptor.of((String)literalClassName, (String)attribute, String.class), getterCreator.getThis()));
                }
                literalClassCreator.close();
            }
        }
    }

    private static void generatePayloadTypeResolver(ClassOutput beanClassOutput, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, Collection<EventDefinition> eventDefinitions) {
        String payloadTypeResolverClassName = GitHubEvent.class.getPackageName() + ".PayloadTypeResolverImpl";
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{payloadTypeResolverClassName}));
        ClassCreator payloadTypeResolverClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(payloadTypeResolverClassName).interfaces(new Class[]{PayloadTypeResolver.class}).build();
        payloadTypeResolverClassCreator.addAnnotation(Singleton.class);
        Map<String, DotName> payloadTypeMapping = eventDefinitions.stream().collect(Collectors.toMap(ed -> ed.getEvent(), ed -> ed.getPayloadType(), (ed1, ed2) -> ed1));
        MethodCreator getPayloadTypeMethodCreator = payloadTypeResolverClassCreator.getMethodCreator("getPayloadType", Class.class, new Class[]{String.class});
        ResultHandle eventRh = getPayloadTypeMethodCreator.getMethodParam(0);
        for (Map.Entry<String, DotName> payloadTypeMappingEntry : payloadTypeMapping.entrySet()) {
            BytecodeCreator matches = getPayloadTypeMethodCreator.ifTrue(getPayloadTypeMethodCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, getPayloadTypeMethodCreator.load(payloadTypeMappingEntry.getKey()), new ResultHandle[]{eventRh})).trueBranch();
            matches.returnValue(matches.loadClass(payloadTypeMappingEntry.getValue().toString()));
        }
        getPayloadTypeMethodCreator.returnValue(getPayloadTypeMethodCreator.loadNull());
        payloadTypeResolverClassCreator.close();
    }

    private static void generateActionMain(ClassOutput beanClassOutput, CombinedIndexBuildItem combinedIndex, LaunchModeBuildItem launchMode, DispatchingConfiguration dispatchingConfiguration, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        String gitHubEventHandlerClassName = GitHubEventHandler.class.getName() + "Impl";
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{gitHubEventHandlerClassName}));
        ClassCreator gitHubEventHandlerClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(gitHubEventHandlerClassName).interfaces(new Class[]{GitHubEventHandler.class}).build();
        gitHubEventHandlerClassCreator.addAnnotation(Singleton.class);
        FieldCreator eventFieldCreator = gitHubEventHandlerClassCreator.getFieldCreator(EVENT_EMITTER_FIELD, Event.class);
        eventFieldCreator.addAnnotation(Inject.class);
        eventFieldCreator.setModifiers(4);
        MethodCreator handleMethodCreator = gitHubEventHandlerClassCreator.getMethodCreator("handle", Void.TYPE, new Class[]{GitHubEvent.class});
        handleMethodCreator.setModifiers(1);
        ResultHandle gitHubEventRh = handleMethodCreator.getMethodParam(0);
        ResultHandle dispatchedNameRh = handleMethodCreator.invokeVirtualMethod(GITHUB_EVENT_GET_NAME, gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedEventRh = handleMethodCreator.invokeVirtualMethod(GITHUB_EVENT_GET_EVENT, gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedActionRh = handleMethodCreator.invokeVirtualMethod(GITHUB_EVENT_GET_EVENT_ACTION, gitHubEventRh, new ResultHandle[0]);
        for (Map.Entry<String, Map<String, DispatchingConfiguration.ActionDispatchingConfiguration>> actionConfigurationEntry : dispatchingConfiguration.getActionConfigurations().entrySet()) {
            String name = actionConfigurationEntry.getKey();
            Map<String, DispatchingConfiguration.ActionDispatchingConfiguration> actionConfiguration = actionConfigurationEntry.getValue();
            BytecodeCreator nameMatchesCreator = handleMethodCreator.ifTrue(handleMethodCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, handleMethodCreator.load(name), new ResultHandle[]{dispatchedNameRh})).trueBranch();
            ResultHandle actionAnnotationLiteralRh = nameMatchesCreator.newInstance(MethodDescriptor.ofConstructor(Action.ActionLiteral.class, (Class[])new Class[]{String.class}), new ResultHandle[]{nameMatchesCreator.load(name)});
            for (Map.Entry<String, DispatchingConfiguration.ActionDispatchingConfiguration> eventConfigurationEntry : actionConfiguration.entrySet()) {
                String event = eventConfigurationEntry.getKey();
                DispatchingConfiguration.ActionDispatchingConfiguration eventDispatchingConfiguration = eventConfigurationEntry.getValue();
                if ("<<ALL>>".equals(event)) {
                    ResultHandle annotationLiteralArrayRh = nameMatchesCreator.newArray(Annotation.class, 1);
                    nameMatchesCreator.writeArrayValue(annotationLiteralArrayRh, 0, actionAnnotationLiteralRh);
                    GitHubActionProcessor.fireEvent(nameMatchesCreator, gitHubEventHandlerClassCreator.getClassName(), gitHubEventRh, annotationLiteralArrayRh);
                    continue;
                }
                BytecodeCreator eventMatchesCreator = nameMatchesCreator.ifTrue(nameMatchesCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, nameMatchesCreator.load(event), new ResultHandle[]{dispatchedEventRh})).trueBranch();
                for (Map.Entry<String, DispatchingConfiguration.EventAnnotation> eventAnnotationEntry : eventDispatchingConfiguration.getEventAnnotations().entrySet()) {
                    String action = eventAnnotationEntry.getKey();
                    DispatchingConfiguration.EventAnnotation eventAnnotation = eventAnnotationEntry.getValue();
                    Object[] literalParameterTypes = new Class[eventAnnotation.getValues().size()];
                    Arrays.fill(literalParameterTypes, String.class);
                    ArrayList<ResultHandle> literalParameters = new ArrayList<ResultHandle>();
                    for (AnnotationValue eventAnnotationValue : eventAnnotation.getValues()) {
                        literalParameters.add(eventMatchesCreator.load(eventAnnotationValue.asString()));
                    }
                    ResultHandle eventAnnotationLiteralRh = eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor((Object)GitHubActionProcessor.getLiteralClassName(eventAnnotation.getName()), (Object[])literalParameterTypes), (ResultHandle[])literalParameters.toArray(ResultHandle[]::new));
                    ResultHandle annotationLiteralArrayRh = eventMatchesCreator.newArray(Annotation.class, 2);
                    eventMatchesCreator.writeArrayValue(annotationLiteralArrayRh, 0, actionAnnotationLiteralRh);
                    eventMatchesCreator.writeArrayValue(annotationLiteralArrayRh, 1, eventAnnotationLiteralRh);
                    if ("*".equals(action)) {
                        GitHubActionProcessor.fireEvent(eventMatchesCreator, gitHubEventHandlerClassCreator.getClassName(), gitHubEventRh, annotationLiteralArrayRh);
                        continue;
                    }
                    BytecodeCreator actionMatchesCreator = eventMatchesCreator.ifTrue(eventMatchesCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, eventMatchesCreator.load(action), new ResultHandle[]{dispatchedActionRh})).trueBranch();
                    GitHubActionProcessor.fireEvent(actionMatchesCreator, gitHubEventHandlerClassCreator.getClassName(), gitHubEventRh, annotationLiteralArrayRh);
                }
            }
        }
        handleMethodCreator.returnValue(null);
        gitHubEventHandlerClassCreator.close();
    }

    private static void generateMultiplexers(ClassOutput beanClassOutput, DispatchingConfiguration dispatchingConfiguration, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (Map.Entry<DotName, TreeSet<DispatchingConfiguration.ActionDispatchingMethod>> actionDispatchingMethodsEntry : dispatchingConfiguration.getMethods().entrySet()) {
            DotName declaringClassName = actionDispatchingMethodsEntry.getKey();
            TreeSet<DispatchingConfiguration.ActionDispatchingMethod> actionDispatchingMethods = actionDispatchingMethodsEntry.getValue();
            ClassInfo declaringClass = actionDispatchingMethods.iterator().next().getMethod().declaringClass();
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{declaringClassName.toString()}));
            String multiplexerClassName = declaringClassName + "_Multiplexer";
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{multiplexerClassName}));
            ClassCreator multiplexerClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(multiplexerClassName).superClass(declaringClassName.toString()).build();
            multiplexerClassCreator.addAnnotation(Multiplexer.class);
            if (!BuiltinScope.isDeclaredOn((ClassInfo)declaringClass)) {
                multiplexerClassCreator.addAnnotation(Singleton.class);
            }
            for (AnnotationInstance classAnnotation : declaringClass.declaredAnnotations()) {
                multiplexerClassCreator.addAnnotation(classAnnotation);
            }
            for (MethodInfo originalConstructor : declaringClass.constructors()) {
                MethodCreator constructorCreator = multiplexerClassCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)multiplexerClassName, (String[])((String[])originalConstructor.parameterTypes().stream().map(t -> t.name().toString()).toArray(String[]::new))));
                List originalMethodAnnotations = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
                for (AnnotationInstance originalMethodAnnotation : originalMethodAnnotations) {
                    constructorCreator.addAnnotation(originalMethodAnnotation);
                }
                Map<Short, List<AnnotationInstance>> originalConstructorParameterAnnotationMapping = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                ArrayList<ResultHandle> parametersRh = new ArrayList<ResultHandle>();
                for (short i = 0; i < originalConstructor.parameterTypes().size(); i = (short)(i + 1)) {
                    parametersRh.add(constructorCreator.getMethodParam((int)i));
                    AnnotatedElement parameterAnnotations = constructorCreator.getParameterAnnotations((int)i);
                    List originalConstructorParameterAnnotations = originalConstructorParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    for (AnnotationInstance originalConstructorParameterAnnotation : originalConstructorParameterAnnotations) {
                        parameterAnnotations.addAnnotation(originalConstructorParameterAnnotation);
                    }
                }
                constructorCreator.invokeSpecialMethod(MethodDescriptor.of((MethodInfo)originalConstructor), constructorCreator.getThis(), (ResultHandle[])parametersRh.toArray(ResultHandle[]::new));
                constructorCreator.returnValue(null);
            }
            for (DispatchingConfiguration.ActionDispatchingMethod actionDispatchingMethod : actionDispatchingMethods) {
                String name = actionDispatchingMethod.getName();
                AnnotationInstance eventSubscriberInstance = actionDispatchingMethod.getEventSubscriberInstance();
                MethodInfo originalMethod = actionDispatchingMethod.getMethod();
                Map<Short, List<AnnotationInstance>> originalMethodParameterAnnotationMapping = originalMethod.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                if (originalMethod.hasAnnotation(DotNames.OBSERVES) || originalMethod.hasAnnotation(DotNames.OBSERVES_ASYNC)) {
                    LOG.warn((Object)("Methods listening to GitHub actions may not be annotated with @Observes or @ObservesAsync. Offending method: " + originalMethod.declaringClass().name() + "#" + originalMethod));
                }
                ArrayList<String> parameterTypes = new ArrayList<String>();
                List originalMethodParameterTypes = originalMethod.parameterTypes();
                short payloadParameterPosition = -1;
                if (eventSubscriberInstance != null) {
                    for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)((short)(i + 1))) {
                        List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                        if (!parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) continue;
                        payloadParameterPosition = i;
                        break;
                    }
                }
                short j = 0;
                HashMap<Short, Short> parameterMapping = new HashMap<Short, Short>();
                for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    List originalMethodAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (originalMethodAnnotations.stream().anyMatch(ai -> GitHubActionDotNames.CONFIG_FILE.equals((Object)ai.name())) || GitHubActionDotNames.INJECTABLE_TYPES.contains(((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name()) || i == payloadParameterPosition) continue;
                    parameterTypes.add(((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name().toString());
                    parameterMapping.put(i, j);
                    j = (short)(j + 1);
                }
                short configFileReaderParameterPosition = -1;
                if (originalMethod.hasAnnotation(GitHubActionDotNames.CONFIG_FILE)) {
                    parameterTypes.add(ConfigFileReader.class.getName());
                    configFileReaderParameterPosition = j;
                    j = (short)(j + 1);
                }
                parameterTypes.add(GitHubEvent.class.getName());
                short gitHubEventParameterPosition = j;
                MethodCreator methodCreator = multiplexerClassCreator.getMethodCreator(originalMethod.name() + "_" + HashUtil.sha1((String)(originalMethod.toString() + "_" + (eventSubscriberInstance != null ? eventSubscriberInstance.toString() : "<<ALL>>"))), (Object)originalMethod.returnType().name().toString(), parameterTypes.toArray());
                for (org.jboss.jandex.Type exceptionType : originalMethod.exceptions()) {
                    methodCreator.addException(exceptionType.name().toString());
                }
                ResultHandle[] parameterValues = new ResultHandle[originalMethod.parameterTypes().size()];
                for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    Short generatedParameterIndex;
                    List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (parameterAnnotations.isEmpty() || (generatedParameterIndex = (Short)parameterMapping.get(i)) == null) continue;
                    AnnotatedElement generatedParameterAnnotations = methodCreator.getParameterAnnotations((int)generatedParameterIndex.shortValue());
                    for (AnnotationInstance annotationInstance : parameterAnnotations) {
                        generatedParameterAnnotations.addAnnotation(annotationInstance);
                    }
                }
                AnnotatedElement gitHubEventParameterAnnotations = methodCreator.getParameterAnnotations((int)gitHubEventParameterPosition);
                gitHubEventParameterAnnotations.addAnnotation(DotNames.OBSERVES.toString());
                gitHubEventParameterAnnotations.addAnnotation(Action.class).addValue("value", (Object)name);
                if (eventSubscriberInstance != null) {
                    gitHubEventParameterAnnotations.addAnnotation(eventSubscriberInstance);
                }
                ResultHandle gitHubEventRh = methodCreator.getMethodParam((int)gitHubEventParameterPosition);
                for (short originalMethodParameterIndex = 0; originalMethodParameterIndex < originalMethodParameterTypes.size(); originalMethodParameterIndex = (short)(originalMethodParameterIndex + 1)) {
                    List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(originalMethodParameterIndex, Collections.emptyList());
                    Short multiplexerMethodParameterIndex = (Short)parameterMapping.get(originalMethodParameterIndex);
                    if (originalMethodParameterIndex == payloadParameterPosition) {
                        parameterValues[originalMethodParameterIndex] = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getPayload", GHEventPayload.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
                        continue;
                    }
                    if (GitHubActionDotNames.INJECTABLE_TYPES.contains(((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name())) {
                        DotName injectableType = ((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name();
                        parameterValues[originalMethodParameterIndex] = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)("get" + injectableType.withoutPackagePrefix()), (Object)injectableType.toString(), (Object[])new Object[0]), gitHubEventRh, new ResultHandle[0]);
                        continue;
                    }
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)GitHubActionDotNames.CONFIG_FILE))) {
                        AnnotationInstance configFileAnnotationInstance = parameterAnnotations.stream().filter(ai -> ai.name().equals((Object)GitHubActionDotNames.CONFIG_FILE)).findFirst().get();
                        String configObjectType = ((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name().toString();
                        boolean isOptional = false;
                        if (Optional.class.getName().equals(configObjectType)) {
                            if (((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).kind() != Type.Kind.PARAMETERIZED_TYPE) {
                                throw new IllegalStateException("Optional is used but not parameterized for method " + originalMethod.declaringClass().name() + "#" + originalMethod);
                            }
                            isOptional = true;
                            configObjectType = ((org.jboss.jandex.Type)((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).asParameterizedType().arguments().get(0)).name().toString();
                        }
                        ResultHandle gitHubRh = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getGitHub", GitHub.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
                        ResultHandle contextRh = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getContext", Context.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
                        ResultHandle repositoryRh = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(Context.class, (String)"getGitHubRepository", String.class, (Class[])new Class[0]), contextRh, new ResultHandle[0]);
                        ResultHandle configFileReaderRh = methodCreator.getMethodParam((int)configFileReaderParameterPosition);
                        ResultHandle configObject = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ConfigFileReader.class, (String)"getConfigObject", Object.class, (Class[])new Class[]{GitHub.class, String.class, String.class, Class.class}), configFileReaderRh, new ResultHandle[]{gitHubRh, repositoryRh, methodCreator.load(configFileAnnotationInstance.value().asString()), methodCreator.loadClass(configObjectType)});
                        configObject = methodCreator.checkCast(configObject, configObjectType);
                        if (isOptional) {
                            configObject = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{configObject});
                        }
                        parameterValues[originalMethodParameterIndex] = configObject;
                        continue;
                    }
                    parameterValues[originalMethodParameterIndex] = methodCreator.getMethodParam((int)multiplexerMethodParameterIndex.shortValue());
                }
                ResultHandle returnValue = methodCreator.invokeVirtualMethod(originalMethod, methodCreator.getThis(), parameterValues);
                methodCreator.returnValue(returnValue);
            }
            multiplexerClassCreator.close();
        }
    }

    private static void fireEvent(BytecodeCreator bytecodeCreator, String className, ResultHandle gitHubEventRh, ResultHandle annotationLiteralArrayRh) {
        ResultHandle cdiEventRh = bytecodeCreator.invokeInterfaceMethod(EVENT_SELECT, bytecodeCreator.readInstanceField(FieldDescriptor.of((String)className, (String)EVENT_EMITTER_FIELD, Event.class), bytecodeCreator.getThis()), new ResultHandle[]{annotationLiteralArrayRh});
        bytecodeCreator.invokeInterfaceMethod(EVENT_FIRE, cdiEventRh, new ResultHandle[]{gitHubEventRh});
    }

    private static String getLiteralClassName(DotName annotationName) {
        return annotationName + "_AnnotationLiteral";
    }

    private static void systemOutPrintln(BytecodeCreator bytecodeCreator, ResultHandle resultHandle) {
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(PrintStream.class, (String)"println", Void.TYPE, (Class[])new Class[]{String.class}), bytecodeCreator.readStaticField(FieldDescriptor.of(System.class, (String)"out", PrintStream.class)), new ResultHandle[]{bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0])});
    }

    private static class RemoveBridgeMethodsClassVisitor
    extends ClassVisitor {
        private static final Logger LOG = Logger.getLogger(RemoveBridgeMethodsClassVisitor.class);
        private final String className;
        private final Set<String> methodsWithBridges;

        public RemoveBridgeMethodsClassVisitor(ClassVisitor visitor, String className, Set<String> methodsWithBridges) {
            super(589824, visitor);
            this.className = className;
            this.methodsWithBridges = methodsWithBridges;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.methodsWithBridges.contains(name) && (access & 0x40) != 0 && (access & 0x1000) != 0) {
                LOG.debugf("Class %1$s - Removing method %2$s %3$s(%4$s)", new Object[]{this.className, Type.getReturnType((String)descriptor), name, Arrays.toString(Type.getArgumentTypes((String)descriptor))});
                return null;
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

