/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubaction.deployment;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class DispatchingConfiguration {
    private final Map<String, Map<String, ActionDispatchingConfiguration>> actionConfigurations = new TreeMap<String, Map<String, ActionDispatchingConfiguration>>();
    private final Map<DotName, TreeSet<ActionDispatchingMethod>> methods = new TreeMap<DotName, TreeSet<ActionDispatchingMethod>>();

    DispatchingConfiguration() {
    }

    Map<String, Map<String, ActionDispatchingConfiguration>> getActionConfigurations() {
        return this.actionConfigurations;
    }

    ActionDispatchingConfiguration getOrCreateActionConfiguration(String action, String event, String payloadType) {
        return this.actionConfigurations.computeIfAbsent(action, a -> new HashMap()).computeIfAbsent(event, et -> new ActionDispatchingConfiguration(event, payloadType));
    }

    Map<DotName, TreeSet<ActionDispatchingMethod>> getMethods() {
        return this.methods;
    }

    List<ActionDispatchingConfiguration> getActionDispatchingConfigurations() {
        return this.actionConfigurations.values().stream().flatMap(innerMap -> innerMap.values().stream()).collect(Collectors.toList());
    }

    void addActionDispatchingMethod(ActionDispatchingMethod actionDispatchingMethod) {
        this.methods.computeIfAbsent(actionDispatchingMethod.getMethod().declaringClass().name(), k -> new TreeSet()).add(actionDispatchingMethod);
    }

    static class ActionDispatchingConfiguration {
        private final String event;
        private final String payloadType;
        private final TreeMap<String, EventAnnotation> eventAnnotations = new TreeMap();

        ActionDispatchingConfiguration(String event, String payloadType) {
            this.event = event;
            this.payloadType = payloadType;
        }

        String getEvent() {
            return this.event;
        }

        String getPayloadType() {
            return this.payloadType;
        }

        TreeMap<String, EventAnnotation> getEventAnnotations() {
            return this.eventAnnotations;
        }

        Set<EventAnnotationLiteral> getEventAnnotationLiterals() {
            HashSet<EventAnnotationLiteral> literals = new HashSet<EventAnnotationLiteral>();
            for (EventAnnotation eventAnnotation : this.eventAnnotations.values()) {
                literals.add(new EventAnnotationLiteral(eventAnnotation.getName(), eventAnnotation.getValues().stream().map(av -> av.name()).collect(Collectors.toList())));
            }
            return literals;
        }

        ActionDispatchingConfiguration addEventAnnotation(String action, AnnotationInstance annotationInstance, List<AnnotationValue> annotationValues) {
            this.eventAnnotations.put(action, new EventAnnotation(annotationInstance.name(), annotationValues));
            return this;
        }
    }

    static class ActionDispatchingMethod
    implements Comparable<ActionDispatchingMethod> {
        private final String name;
        private final AnnotationInstance eventSubscriberInstance;
        private final MethodInfo method;

        ActionDispatchingMethod(String name, AnnotationInstance eventSubscriberInstance, MethodInfo method) {
            this.name = name;
            this.eventSubscriberInstance = eventSubscriberInstance;
            this.method = method;
        }

        String getName() {
            return this.name;
        }

        AnnotationInstance getEventSubscriberInstance() {
            return this.eventSubscriberInstance;
        }

        MethodInfo getMethod() {
            return this.method;
        }

        @Override
        public int compareTo(ActionDispatchingMethod other) {
            int classNameCompareTo = this.method.declaringClass().name().compareTo(other.method.declaringClass().name());
            if (classNameCompareTo != 0) {
                return classNameCompareTo;
            }
            int methodNameComparator = this.method.toString().compareTo(other.method.toString());
            if (methodNameComparator != 0) {
                return methodNameComparator;
            }
            int nameComparator = this.name.compareTo(other.name);
            if (nameComparator != 0) {
                return nameComparator;
            }
            if (this.eventSubscriberInstance != null) {
                return this.eventSubscriberInstance.toString(false).compareTo(other.eventSubscriberInstance.toString(false));
            }
            return 0;
        }
    }

    static class EventAnnotationLiteral {
        private final DotName name;
        private final List<String> attributes;

        EventAnnotationLiteral(DotName name, List<String> attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        DotName getName() {
            return this.name;
        }

        List<String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventAnnotationLiteral other = (EventAnnotationLiteral)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.attributes, other.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.attributes);
        }
    }

    static class EventAnnotation
    implements Comparable<EventAnnotation> {
        private final DotName name;
        private final List<AnnotationValue> values;

        EventAnnotation(DotName name, List<AnnotationValue> values) {
            this.name = name;
            this.values = values;
        }

        DotName getName() {
            return this.name;
        }

        List<AnnotationValue> getValues() {
            return this.values;
        }

        @Override
        public int compareTo(EventAnnotation other) {
            int nameCompareTo = this.name.compareTo(other.name);
            if (nameCompareTo != 0) {
                return nameCompareTo;
            }
            int valuesLengthCompare = Integer.compare(this.values.size(), other.values.size());
            if (valuesLengthCompare != 0) {
                return valuesLengthCompare;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                int valueCompare = this.values.get(i).asString().compareTo(other.values.get(i).asString());
                if (valueCompare == 0) continue;
                return valueCompare;
            }
            return 0;
        }
    }
}

