/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface CommandOptions {
    public static final CommandScope DEFAULT_SCOPE = CommandScope.ISSUES_AND_PULL_REQUESTS;
    public static final ExecutionErrorStrategy DEFAULT_EXECUTION_ERROR_STRATEGY = ExecutionErrorStrategy.NONE;
    public static final String DEFAULT_EXECUTION_ERROR_MESSAGE = ":warning: An error occurred while executing command: %s";

    public CommandScope scope() default CommandScope.ISSUES_AND_PULL_REQUESTS;

    public ExecutionErrorStrategy executionErrorStrategy() default ExecutionErrorStrategy.NONE;

    public String executionErrorMessage() default ":warning: An error occurred while executing command: %s";

    public static enum CommandScope {
        ISSUES,
        PULL_REQUESTS,
        ISSUES_AND_PULL_REQUESTS;


        public boolean isInScope(boolean isPullRequest) {
            if (isPullRequest) {
                return this == ISSUES_AND_PULL_REQUESTS || this == PULL_REQUESTS;
            }
            return this == ISSUES_AND_PULL_REQUESTS || this == ISSUES;
        }
    }

    public static enum ExecutionErrorStrategy {
        NONE(false),
        COMMENT_MESSAGE(true);

        private final boolean message;

        private ExecutionErrorStrategy(boolean message) {
            this.message = message;
        }

        public boolean addMessage() {
            return this.message;
        }
    }
}

