/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.github;

import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRepository;

@ApplicationScoped
public class GitHubFileDownloader {
    private static final Logger LOG = Logger.getLogger(GitHubFileDownloader.class);
    @Inject
    LaunchMode launchMode;

    public Optional<String> getFileContent(GHRepository ghRepository, String ref, String fullPath) {
        try {
            GHContent ghContent = ghRepository.getFileContent(fullPath);
            return Optional.of(ghContent.getContent());
        }
        catch (GHFileNotFoundException e) {
            if (this.launchMode.isDevOrTest()) {
                LOG.warn((Object)("Unable to read file " + fullPath + " for repository " + ghRepository.getFullName() + ". Either the file does not exist or the 'Contents' permission has not been set for the application."));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error downloading file " + fullPath + " for repository " + ghRepository.getFullName(), e);
        }
    }
}

