/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.smee;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.MessageEvent;
import io.quarkiverse.githubapp.runtime.Headers;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import java.net.URI;
import java.time.Duration;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

@ApplicationScoped
@Startup
public class SmeeIoForwarder {
    private static final String EMPTY_MESSAGE = "{}";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final EventSource eventSource;

    @Inject
    SmeeIoForwarder(CheckedConfigProvider checkedConfigProvider, HttpConfiguration httpConfiguration, ObjectMapper objectMapper) {
        if (!checkedConfigProvider.webhookProxyUrl().isPresent()) {
            this.eventSource = null;
            return;
        }
        String localUrl = "http://" + httpConfiguration.host + ":" + httpConfiguration.port + "/";
        this.eventSource = SmeeIoForwarder.startEventSource(checkedConfigProvider.webhookProxyUrl().get(), localUrl, new OkHttpClient(), objectMapper);
    }

    void stopEventSource(@Observes ShutdownEvent shutdownEvent) {
        if (this.eventSource != null) {
            this.eventSource.close();
        }
    }

    private static EventSource startEventSource(String webhookProxyUrl, String localUrl, OkHttpClient client, ObjectMapper objectMapper) {
        EventSource.Builder builder = new EventSource.Builder((EventHandler)new SimpleEventHandler(localUrl, client, objectMapper), URI.create(webhookProxyUrl)).reconnectTime(Duration.ofMillis(3000L));
        EventSource eventSource = builder.build();
        eventSource.start();
        return eventSource;
    }

    private static class SimpleEventHandler
    implements EventHandler {
        private final OkHttpClient client;
        private final String localUrl;
        private final ObjectMapper objectMapper;

        private SimpleEventHandler(String localUrl, OkHttpClient client, ObjectMapper objectMapper) {
            this.client = client;
            this.localUrl = localUrl;
            this.objectMapper = objectMapper;
        }

        public void onOpen() throws Exception {
        }

        public void onClosed() throws Exception {
        }

        public void onMessage(String event, MessageEvent messageEvent) throws Exception {
            if (SmeeIoForwarder.EMPTY_MESSAGE.equals(messageEvent.getData())) {
                return;
            }
            JsonNode rootNode = this.objectMapper.readTree(messageEvent.getData());
            JsonNode body = rootNode.get("body");
            if (body != null) {
                Request.Builder requestBuilder = new Request.Builder().url(this.localUrl).post(RequestBody.create((MediaType)JSON, (String)this.objectMapper.writeValueAsString((Object)rootNode.get("body"))));
                for (String forwardedHeader : Headers.FORWARDED_HEADERS) {
                    JsonNode headerValue = rootNode.get(forwardedHeader.toLowerCase(Locale.ROOT));
                    if (headerValue == null || !headerValue.isTextual()) continue;
                    requestBuilder.addHeader(forwardedHeader, headerValue.textValue());
                }
                Response response = this.client.newCall(requestBuilder.build()).execute();
                if (response != null) {
                    response.close();
                }
            }
        }

        public void onComment(String comment) throws Exception {
        }

        public void onError(Throwable t) {
        }
    }
}

