/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.github;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.quarkiverse.githubapp.GitHubClientProvider;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.github.CachedInstallationToken;
import io.quarkiverse.githubapp.runtime.signing.JwtTokenCreator;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClientBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

@ApplicationScoped
public class GitHubService
implements GitHubClientProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String AUTHORIZATION_HEADER_BEARER = "Bearer %s";
    private final CheckedConfigProvider checkedConfigProvider;
    private final LoadingCache<Long, CachedInstallationToken> installationTokenCache;
    private final JwtTokenCreator jwtTokenCreator;

    @Inject
    public GitHubService(CheckedConfigProvider checkedConfigProvider, JwtTokenCreator jwtTokenCreator) {
        this.checkedConfigProvider = checkedConfigProvider;
        this.jwtTokenCreator = jwtTokenCreator;
        this.installationTokenCache = Caffeine.newBuilder().maximumSize(50L).expireAfter((Expiry)new Expiry<Long, CachedInstallationToken>(){

            public long expireAfterCreate(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime) {
                long millis = cachedInstallationGitHub.getExpiresAt().minus(System.currentTimeMillis(), ChronoUnit.MILLIS).minus(10L, ChronoUnit.MINUTES).toEpochMilli();
                return TimeUnit.MILLISECONDS.toNanos(millis);
            }

            public long expireAfterUpdate(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime, long currentDuration) {
                return currentDuration;
            }

            public long expireAfterRead(Long installationId, CachedInstallationToken cachedInstallationGitHub, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).build((CacheLoader)new CreateInstallationToken());
    }

    @Override
    public GitHub getInstallationClient(long installationId) {
        try {
            return this.createInstallationClient(installationId);
        }
        catch (IOException e1) {
            GitHubService gitHubService = this;
            synchronized (gitHubService) {
                try {
                    return this.createInstallationClient(installationId);
                }
                catch (IOException e2) {
                    try {
                        this.installationTokenCache.invalidate((Object)installationId);
                        return this.createInstallationClient(installationId);
                    }
                    catch (IOException e3) {
                        throw new IllegalStateException("Unable to create a GitHub client for the installation " + installationId, e3);
                    }
                }
            }
        }
    }

    @Override
    public DynamicGraphQLClient getInstallationGraphQLClient(long installationId) {
        try {
            return this.createInstallationGraphQLClient(installationId);
        }
        catch (IOException | InterruptedException | ExecutionException e1) {
            GitHubService gitHubService = this;
            synchronized (gitHubService) {
                try {
                    return this.createInstallationGraphQLClient(installationId);
                }
                catch (IOException | InterruptedException | ExecutionException e2) {
                    try {
                        this.installationTokenCache.invalidate((Object)installationId);
                        return this.createInstallationGraphQLClient(installationId);
                    }
                    catch (IOException | InterruptedException | ExecutionException e3) {
                        throw new IllegalStateException("Unable to create a GitHub GraphQL client for the installation " + installationId, e3);
                    }
                }
            }
        }
    }

    private GitHub createInstallationClient(long installationId) throws IOException {
        CachedInstallationToken installationToken = (CachedInstallationToken)this.installationTokenCache.get((Object)installationId);
        GitHubBuilder gitHubBuilder = new GitHubBuilder().withAppInstallationToken(installationToken.getToken()).withEndpoint(this.checkedConfigProvider.restApiEndpoint());
        GitHub gitHub = gitHubBuilder.build();
        gitHub.getRateLimit();
        return gitHub;
    }

    private DynamicGraphQLClient createInstallationGraphQLClient(long installationId) throws IOException, ExecutionException, InterruptedException {
        CachedInstallationToken installationToken = (CachedInstallationToken)this.installationTokenCache.get((Object)installationId);
        DynamicGraphQLClient graphQLClient = DynamicGraphQLClientBuilder.newBuilder().url(this.checkedConfigProvider.graphqlApiEndpoint()).header(AUTHORIZATION_HEADER, String.format(AUTHORIZATION_HEADER_BEARER, installationToken.getToken())).build();
        graphQLClient.executeSync("query {\nrateLimit {\n    limit\n    cost\n    remaining\n    resetAt\n  }\n}");
        return graphQLClient;
    }

    @Override
    public GitHub getApplicationClient() {
        return this.createApplicationGitHub();
    }

    private GitHub createApplicationGitHub() {
        String jwtToken;
        try {
            jwtToken = this.jwtTokenCreator.createJwtToken(this.checkedConfigProvider.appId(), this.checkedConfigProvider.privateKey(), 540L);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Unable to generate the JWT token", e);
        }
        try {
            GitHubBuilder gitHubBuilder = new GitHubBuilder().withJwtToken(jwtToken).withEndpoint(this.checkedConfigProvider.restApiEndpoint());
            return gitHubBuilder.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create a GitHub client for the application", e);
        }
    }

    private class CreateInstallationToken
    implements CacheLoader<Long, CachedInstallationToken> {
        private CreateInstallationToken() {
        }

        public CachedInstallationToken load(Long installationId) throws Exception {
            try {
                GHAppInstallationToken installationToken = GitHubService.this.createApplicationGitHub().getApp().getInstallationById(installationId.longValue()).createToken().create();
                return new CachedInstallationToken(installationToken.getToken(), installationToken.getExpiresAt());
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create a GitHub token for the installation " + installationId, e);
            }
        }
    }
}

