/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.signing;

import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Singleton;

@Singleton
public class PayloadSignatureChecker {
    private static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    private static final String HEADER_SIGNATURE_PREFIX = "sha256=";
    private final SecretKeySpec secretKeySpec;
    private final Mac sharedMac;
    private final boolean supportsClone;

    PayloadSignatureChecker(CheckedConfigProvider checkedConfigProvider) {
        if (!checkedConfigProvider.webhookSecret().isPresent()) {
            this.secretKeySpec = null;
            this.sharedMac = null;
            this.supportsClone = false;
            return;
        }
        this.secretKeySpec = new SecretKeySpec(checkedConfigProvider.webhookSecret().get().getBytes(StandardCharsets.UTF_8), HMAC_SHA256_ALGORITHM);
        this.sharedMac = PayloadSignatureChecker.createNewMacInstance(this.secretKeySpec);
        this.supportsClone = PayloadSignatureChecker.supportsClone(this.sharedMac);
    }

    public boolean matches(byte[] payload, String headerSignature) {
        if (this.secretKeySpec == null || this.sharedMac == null) {
            throw new IllegalStateException("Payload signature checking is disabled, this method should not be called");
        }
        String payloadSignature = PayloadSignatureChecker.hex(this.getMacInstance().doFinal(payload));
        return MessageDigest.isEqual(payloadSignature.getBytes(), headerSignature.substring(HEADER_SIGNATURE_PREFIX.length()).getBytes());
    }

    public static boolean supportsClone(Mac mac) {
        try {
            mac.clone();
            return true;
        }
        catch (CloneNotSupportedException e) {
            return false;
        }
    }

    public Mac getMacInstance() {
        if (this.supportsClone) {
            try {
                return (Mac)this.sharedMac.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return PayloadSignatureChecker.createNewMacInstance(this.secretKeySpec);
    }

    public static Mac createNewMacInstance(SecretKeySpec secretKeySpec) {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(secretKeySpec);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to initialize the payload signature checker", e);
        }
    }

    public static String hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte aByte : bytes) {
            result.append(String.format("%02x", aByte));
        }
        return result.toString();
    }
}

