/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.config.GitHubAppRuntimeConfig;
import io.quarkiverse.githubapp.runtime.replay.ReplayEventsRoute;
import io.quarkiverse.githubapp.runtime.signing.PayloadSignatureChecker;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.StartupEvent;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.web.Header;
import io.quarkus.vertx.web.Route;
import io.quarkus.vertx.web.RoutingExchange;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class Routes {
    private static final Logger LOG = Logger.getLogger((String)GitHubEvent.class.getPackageName());
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    @Inject
    Event<GitHubEvent> gitHubEventEmitter;
    @Inject
    GitHubAppRuntimeConfig gitHubAppRuntimeConfig;
    @Inject
    PayloadSignatureChecker payloadSignatureChecker;
    @Inject
    LaunchMode launchMode;
    @Inject
    Instance<ReplayEventsRoute> replayRouteInstance;
    @Inject
    HttpConfiguration httpConfig;
    Path tmpDirectory;

    public void init(@Observes StartupEvent startupEvent) throws IOException {
        if (this.gitHubAppRuntimeConfig.webhookSecret.isPresent() && this.launchMode.isDevOrTest()) {
            LOG.info((Object)"Payload signature checking is disabled in dev and test modes.");
        }
        if (this.gitHubAppRuntimeConfig.debug.payloadDirectory.isPresent()) {
            Files.createDirectories(this.gitHubAppRuntimeConfig.debug.payloadDirectory.get(), new FileAttribute[0]);
            LOG.warn((Object)("Payloads saved to: " + this.gitHubAppRuntimeConfig.debug.payloadDirectory.get().toAbsolutePath().toString()));
        }
    }

    @Route(path="/", type=Route.HandlerType.BLOCKING, methods={Route.HttpMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public void handleRequest(RoutingContext routingContext, RoutingExchange routingExchange, @Header(value="X-Request-ID") String requestId, @Header(value="X-Hub-Signature-256") String hubSignature, @Header(value="X-GitHub-Delivery") String deliveryId, @Header(value="X-GitHub-Event") String event, @Header(value="X-Quarkiverse-GitHub-App-Replayed") String replayed) throws IOException {
        if (!this.launchMode.isDevOrTest() && (Routes.isBlank(deliveryId) || Routes.isBlank(hubSignature))) {
            routingExchange.response().setStatusCode(400).end();
            return;
        }
        JsonObject body = routingContext.getBodyAsJson();
        if (body == null) {
            routingExchange.ok().end();
            return;
        }
        byte[] bodyBytes = routingContext.getBody().getBytes();
        String action = body.getString("action");
        if (!Routes.isBlank(deliveryId) && this.gitHubAppRuntimeConfig.debug.payloadDirectory.isPresent()) {
            String fileName = DATE_TIME_FORMATTER.format(LocalDateTime.now()) + "-" + event + "-" + (String)(!Routes.isBlank(action) ? action + "-" : "") + deliveryId + ".json";
            Files.write(this.gitHubAppRuntimeConfig.debug.payloadDirectory.get().resolve(fileName), bodyBytes, new OpenOption[0]);
        }
        Long installationId = Routes.extractInstallationId(body);
        String repository = Routes.extractRepository(body);
        GitHubEvent gitHubEvent = new GitHubEvent(installationId, this.gitHubAppRuntimeConfig.appName.orElse(null), deliveryId, repository, event, action, routingContext.getBodyAsString(), body, "true".equals(replayed));
        if (this.launchMode == LaunchMode.DEVELOPMENT && this.replayRouteInstance.isResolvable()) {
            ((ReplayEventsRoute)this.replayRouteInstance.get()).pushEvent(gitHubEvent);
        }
        if (this.gitHubAppRuntimeConfig.webhookSecret.isPresent() && !this.launchMode.isDevOrTest() && !this.payloadSignatureChecker.matches(bodyBytes, hubSignature)) {
            StringBuilder signatureError = new StringBuilder("Invalid signature for delivery: ").append(deliveryId).append("\n");
            signatureError.append("\u203a Signature: ").append(hubSignature);
            LOG.error((Object)signatureError.toString());
            routingExchange.response().setStatusCode(400).end("Invalid signature.");
            return;
        }
        this.gitHubEventEmitter.fire((Object)gitHubEvent);
        routingExchange.ok().end();
    }

    private static boolean isBlank(String value) {
        return value == null || value.isBlank();
    }

    private static Long extractInstallationId(JsonObject body) {
        Long installationId;
        JsonObject installation = body.getJsonObject("installation");
        if (installation != null && (installationId = installation.getLong("id")) != null) {
            return installationId;
        }
        throw new IllegalStateException("Unable to extract installation id from payload");
    }

    private static String extractRepository(JsonObject body) {
        JsonObject repository = body.getJsonObject("repository");
        if (repository == null) {
            return null;
        }
        return repository.getString("full_name");
    }
}

