/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.config;

import io.quarkiverse.githubapp.ConfigFile;
import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.runtime.config.GitHubAppConfigurationException;
import io.quarkiverse.githubapp.runtime.config.GitHubAppRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.Startup;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.security.PrivateKey;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;

@Singleton
@Startup
public class CheckedConfigProvider {
    private static final Logger LOG = Logger.getLogger((String)GitHubEvent.class.getPackageName());
    private final GitHubAppRuntimeConfig gitHubAppRuntimeConfig;
    private final LaunchMode launchMode;
    private final Set<String> missingPropertyKeys = new TreeSet<String>();

    @Inject
    CheckedConfigProvider(GitHubAppRuntimeConfig gitHubAppRuntimeConfig, LaunchMode launchMode) {
        this.gitHubAppRuntimeConfig = gitHubAppRuntimeConfig;
        this.launchMode = launchMode;
        if (gitHubAppRuntimeConfig.appId.isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.app-id (.env: QUARKUS_GITHUB_APP_APP_ID)");
        }
        if (gitHubAppRuntimeConfig.privateKey.isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.private-key (.env: QUARKUS_GITHUB_APP_PRIVATE_KEY)");
        }
        if (launchMode == LaunchMode.NORMAL && gitHubAppRuntimeConfig.webhookSecret.isEmpty()) {
            this.missingPropertyKeys.add("quarkus.github-app.webhook-secret (.env: QUARKUS_GITHUB_APP_WEBHOOK_SECRET)");
        }
        if (launchMode != LaunchMode.TEST) {
            this.checkConfig();
        }
        if (gitHubAppRuntimeConfig.webhookSecret.isPresent() && launchMode.isDevOrTest()) {
            LOG.info((Object)"Payload signature checking is disabled in dev and test modes.");
        }
    }

    public String appId() {
        if (this.launchMode == LaunchMode.TEST) {
            this.checkConfig();
        }
        return this.gitHubAppRuntimeConfig.appId.orElseThrow();
    }

    public Optional<String> appName() {
        return this.gitHubAppRuntimeConfig.appName;
    }

    public PrivateKey privateKey() {
        if (this.launchMode == LaunchMode.TEST) {
            this.checkConfig();
        }
        return this.gitHubAppRuntimeConfig.privateKey.orElseThrow();
    }

    public Optional<String> webhookSecret() {
        return this.gitHubAppRuntimeConfig.webhookSecret;
    }

    public Optional<String> webhookProxyUrl() {
        return this.gitHubAppRuntimeConfig.webhookProxyUrl;
    }

    public String restApiEndpoint() {
        return this.gitHubAppRuntimeConfig.restApiEndpoint;
    }

    public String graphqlApiEndpoint() {
        return this.gitHubAppRuntimeConfig.graphqlApiEndpoint;
    }

    public GitHubAppRuntimeConfig.Debug debug() {
        return this.gitHubAppRuntimeConfig.debug;
    }

    public ConfigFile.Source getEffectiveSource(ConfigFile.Source source) {
        if (source == ConfigFile.Source.DEFAULT) {
            return this.gitHubAppRuntimeConfig.readConfigFilesFromSourceRepository ? ConfigFile.Source.SOURCE_REPOSITORY : ConfigFile.Source.CURRENT_REPOSITORY;
        }
        return source;
    }

    public void checkConfig() {
        if (this.missingPropertyKeys.isEmpty()) {
            return;
        }
        String errorMessage = this.launchMode == LaunchMode.TEST ? "\n\nMissing values for configuration properties:\n- " + String.join((CharSequence)"\n- ", this.missingPropertyKeys) + "\n\nThis configuration is necessary to create the GitHub clients.It is optional in tests only if GitHub clients are being mocked using quarkus-github-app-testing.\n\nFor more information, see https://docs.quarkiverse.io/quarkus-github-app/dev/testing.html." : "\n\nMissing values for configuration properties:\n- " + String.join((CharSequence)"\n- ", this.missingPropertyKeys) + "\n\nThis configuration is required in " + (this.launchMode == LaunchMode.NORMAL ? "prod" : "dev") + " mode.\n\nFor more information, see:\n- https://docs.quarkiverse.io/quarkus-github-app/dev/register-github-app.html\n- https://docs.quarkiverse.io/quarkus-github-app/dev/create-github-app.html#_initialize_the_configuration";
        throw new GitHubAppConfigurationException(errorMessage);
    }
}

