/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.error;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkiverse.githubapp.runtime.github.PayloadHelper;
import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;

@ApplicationScoped
@DefaultBean
public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger LOG = Logger.getLogger((String)GitHubEvent.class.getPackageName());
    private static final String REDELIVERY_URL = "https://github.com/settings/apps/%1$s/advanced";
    @Inject
    LaunchMode launchMode;

    @Override
    public void handleError(GitHubEvent gitHubEvent, GHEventPayload payload, Throwable t) {
        Optional<String> context;
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Error handling delivery " + gitHubEvent.getDeliveryId() + "\n");
        if (gitHubEvent.getRepository().isPresent()) {
            errorMessage.append("\u203a Repository: " + gitHubEvent.getRepository().get() + "\n");
        }
        errorMessage.append("\u203a Event:      " + gitHubEvent.getEventAction() + "\n");
        if (payload != null && (context = PayloadHelper.getContext(payload)).isPresent()) {
            errorMessage.append("\u203a Context:    " + PayloadHelper.getContext(payload).get() + "\n");
        }
        if (gitHubEvent.getAppName().isPresent()) {
            errorMessage.append("\u203a Redeliver:  " + String.format(REDELIVERY_URL, gitHubEvent.getAppName().get()) + "\n");
        }
        if (this.launchMode.isDevOrTest()) {
            errorMessage.append("\u203a Payload:\n").append("----\n").append(gitHubEvent.getParsedPayload().encodePrettily()).append("\n").append("----\n");
        }
        errorMessage.append("Exception");
        LOG.error((Object)errorMessage.toString(), t);
    }
}

