/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.runtime.config;

import io.quarkiverse.githubapp.runtime.config.PrivateKeyConverter;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.TrimmedStringConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.util.Optional;

@ConfigRoot(phase=ConfigPhase.RUN_TIME)
@ConfigMapping(prefix="quarkus.github-app")
public interface GitHubAppRuntimeConfig {
    @WithConverter(value=TrimmedStringConverter.class)
    public Optional<String> appId();

    @WithConverter(value=TrimmedStringConverter.class)
    public Optional<String> appName();

    @WithDefault(value="false")
    public boolean readConfigFilesFromSourceRepository();

    @WithConverter(value=PrivateKeyConverter.class)
    public Optional<PrivateKey> privateKey();

    @WithDefault(value="/")
    @WithConverter(value=TrimmedStringConverter.class)
    public String webhookUrlPath();

    public Optional<String> webhookSecret();

    @WithConverter(value=TrimmedStringConverter.class)
    public Optional<String> credentialsProvider();

    @WithConverter(value=TrimmedStringConverter.class)
    public Optional<String> credentialsProviderName();

    @WithConverter(value=TrimmedStringConverter.class)
    public Optional<String> webhookProxyUrl();

    @WithDefault(value="https://api.github.com")
    @WithConverter(value=TrimmedStringConverter.class)
    public String instanceEndpoint();

    @WithDefault(value="${quarkus.github-app.instance-endpoint}")
    @WithConverter(value=TrimmedStringConverter.class)
    public String restApiEndpoint();

    @WithDefault(value="${quarkus.github-app.instance-endpoint}/graphql")
    @WithConverter(value=TrimmedStringConverter.class)
    public String graphqlApiEndpoint();

    public Optional<String> personalAccessToken();

    public Debug debug();

    @ConfigGroup
    public static interface Debug {
        @WithConverter(value=TrimmedStringConverter.class)
        public Optional<Path> payloadDirectory();
    }
}

