/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jef.java.embedded.framework.linux.core.natives;

import io.quarkiverse.jef.java.embedded.framework.linux.core.Errno;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.CUtil;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.ErrnoNativeHeaders;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;

@CContext(value=ErrnoNativeHeaders.class)
@CLibrary(value="c")
public class ErrnoNative
extends Errno {
    public int ierrno() {
        return Delegate.errno();
    }

    public String strerror(int number) {
        return CUtil.fromCString(Delegate.strerror(number));
    }

    public int perror(String err) {
        return Delegate.perror(CUtil.toCString(err));
    }

    public String strerror() {
        return this.strerror(this.ierrno());
    }

    public boolean isNativeSupported() {
        return true;
    }

    private static class Delegate {
        private Delegate() {
        }

        @CConstant
        public static native int errno();

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native CCharPointer strerror(int var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int perror(CCharPointer var0);
    }
}

