/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jef.java.embedded.framework.linux.core.natives;

import io.quarkiverse.jef.java.embedded.framework.linux.core.Fcntl;
import io.quarkiverse.jef.java.embedded.framework.linux.core.IOFlags;
import io.quarkiverse.jef.java.embedded.framework.linux.core.io.FileHandle;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.CUtil;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.FcntlNativeHeaders;
import io.quarkiverse.jef.java.embedded.framework.linux.core.util.StringUtils;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

@CContext(value=FcntlNativeHeaders.class)
@CLibrary(value="c")
public class FcntlNative
extends Fcntl {
    private static final Logger log = Logger.getLogger(FcntlNative.class.getName());

    public int open(String pathname, EnumSet<IOFlags> flags) {
        int mask = FcntlNative.IOFlagsMask(flags);
        log.log(Level.FINEST, () -> String.format("fctl.native open %s with flags %d", pathname, mask));
        return Delegate.open(CUtil.toCString(pathname), mask);
    }

    public int open64(String pathname, EnumSet<IOFlags> flags) {
        int mask = FcntlNative.IOFlagsMask(flags);
        log.log(Level.FINEST, () -> String.format("fctl.native open64 %s with flags %d", pathname, mask));
        return Delegate.open64(CUtil.toCString(pathname), mask);
    }

    public int close(int fd) {
        log.log(Level.FINEST, () -> String.format("fctl.native close descriptor '%d'", fd));
        return Delegate.close(fd);
    }

    public int read(FileHandle fd, byte[] buffer, int size) {
        log.log(Level.FINEST, () -> String.format("fctl.native read from '%d' length '%d'", fd.getHandle(), size));
        try (PinnedObject pin = PinnedObject.create((Object)buffer);){
            CCharPointer rawData = (CCharPointer)pin.addressOfArrayElement(0);
            int result = Delegate.read(fd.getHandle(), rawData, size);
            log.log(Level.FINEST, () -> StringUtils.dump((byte[])buffer));
            int n = result;
            return n;
        }
    }

    public int write(FileHandle fd, byte[] buffer, int size) {
        try (PinnedObject pin = PinnedObject.create((Object)buffer);){
            CCharPointer rawData = (CCharPointer)pin.addressOfArrayElement(0);
            int n = Delegate.write(fd.getHandle(), rawData, size);
            return n;
        }
    }

    public int fsync(FileHandle fd) {
        return Delegate.fsync(fd.getHandle());
    }

    public long lseek(FileHandle fd, long offset, Fcntl.Whence whence) {
        return Delegate.lseek(fd.getHandle(), offset, whence.getValue());
    }

    public int fcntl(FileHandle fd, int cmd, EnumSet<IOFlags> flags) {
        int mask = FcntlNative.IOFlagsMask(flags);
        return Delegate.fcntl(fd.getHandle(), mask);
    }

    public boolean isNativeSupported() {
        return true;
    }

    private static class Delegate {
        private Delegate() {
        }

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        private static native int open(CCharPointer var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int open64(CCharPointer var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int close(int var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int read(int var0, CCharPointer var1, int var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int write(int var0, CCharPointer var1, int var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int fsync(int var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int ioctl(int var0, long var1, long var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int ioctl(int var0, long var1, PointerBase var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int fcntl(int var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native long lseek(int var0, long var1, int var3);
    }
}

