/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jef.java.embedded.framework.linux.core.natives;

import io.quarkiverse.jef.java.embedded.framework.linux.core.Ioctl;
import io.quarkiverse.jef.java.embedded.framework.linux.core.LinuxUtils;
import io.quarkiverse.jef.java.embedded.framework.linux.core.NativeIOException;
import io.quarkiverse.jef.java.embedded.framework.linux.core.io.FileHandle;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.IoctlNativeHeaders;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.gpio.GpioNativeStructures;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.i2c.I2CData;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.spi.SpiIocTransferNative;
import io.quarkiverse.jef.java.embedded.framework.linux.core.types.IntReference;
import io.quarkiverse.jef.java.embedded.framework.linux.core.types.LongReference;
import io.quarkiverse.jef.java.embedded.framework.linux.core.types.SmbusData;
import io.quarkiverse.jef.java.embedded.framework.linux.core.types.SmbusIoctlData;
import io.quarkiverse.jef.java.embedded.framework.linux.core.types.SpiIocTransfer;
import io.quarkiverse.jef.java.embedded.framework.linux.core.util.StringUtils;
import io.quarkiverse.jef.java.embedded.framework.linux.gpio.GpioChipInfo;
import io.quarkiverse.jef.java.embedded.framework.linux.gpio.GpioHandleData;
import io.quarkiverse.jef.java.embedded.framework.linux.gpio.GpioHandleRequest;
import io.quarkiverse.jef.java.embedded.framework.linux.gpio.GpioLineInfo;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

@CContext(value=IoctlNativeHeaders.class)
@CLibrary(value="c")
public class IoctlNative
extends Ioctl {
    private static final Logger log = Logger.getLogger(IoctlNative.class.getName());

    @CConstant
    private static native long _IOC_NRBITS();

    @CConstant
    private static native long _IOC_TYPEBITS();

    @CConstant
    private static native long _IOC_SIZEBITS();

    @CConstant
    private static native long _IOC_DIRBITS();

    @CConstant
    private static native long _IOC_NRSHIFT();

    @CConstant
    private static native long _IOC_NONE();

    @CConstant
    private static native long _IOC_READ();

    @CConstant
    private static native long _IOC_WRITE();

    @CConstant
    private static native long SPI_IOC_MAGIC();

    public boolean isNativeSupported() {
        return true;
    }

    public int ioctl(FileHandle fd, long command, long arg) throws NativeIOException {
        log.log(Level.FINEST, String.format("ioctl by long fd is '%d' command: '%8h' arg: '0x%8h'", fd.getHandle(), command, arg));
        int result = Delegate.ioctl(fd.getHandle(), command, arg);
        LinuxUtils.checkIOResult((String)"ioctl:long", (int)result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle fd, long command, LongReference arg) throws NativeIOException {
        log.log(Level.FINEST, String.format("ioctl by long reference fd is '%d' command is '%8h' arg is '0x%8h'", fd.getHandle(), command, arg.getValue()));
        CLongPointer ptr = (CLongPointer)UnmanagedMemory.malloc((int)8);
        ptr.write(0, arg.getValue());
        try {
            int result = Delegate.ioctl(fd.getHandle(), command, ptr);
            LinuxUtils.checkIOResult((String)"ioctl:LongRef", (int)result);
            long refValue = ptr.read();
            arg.setValue(refValue);
            log.log(Level.FINEST, String.format("ioctl by long reference fd is '%d' command is '%8h' arg is '0x%8h' results '%d'", fd.getHandle(), command, arg.getValue(), refValue));
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle fd, long command, IntReference arg) throws NativeIOException {
        log.log(Level.FINEST, String.format("ioctl by int reference fd is '%d' command is '%8h' arg is '0x%8h'", fd.getHandle(), command, arg.getValue()));
        CIntPointer ptr = (CIntPointer)UnmanagedMemory.malloc((int)4);
        ptr.write(0, arg.getValue());
        try {
            int result = Delegate.ioctl(fd.getHandle(), command, (PointerBase)ptr);
            log.log(Level.FINEST, () -> String.format("ioctl result is '%s'", result));
            LinuxUtils.checkIOResult((String)"ioctl:IntRef", (int)result);
            int refValue = ptr.read();
            arg.setValue(refValue);
            log.log(Level.FINEST, String.format("ioctl by int reference fd is '%d' command is '%8h' arg is '0x%8h' results '%d'", fd.getHandle(), command, arg.getValue(), refValue));
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)ptr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle fd, long command, SmbusIoctlData ptr) throws NativeIOException {
        log.log(Level.FINEST, () -> String.format("ioctl.smbus fd is '%d' data is '%s'", fd.getHandle(), ptr));
        I2CData.I2CSmbusIoctlData ioctl = (I2CData.I2CSmbusIoctlData)UnmanagedMemory.malloc((int)SizeOf.get(I2CData.I2CSmbusIoctlData.class));
        I2CData.I2CSmbusData smbusData = (I2CData.I2CSmbusData)UnmanagedMemory.malloc((int)SizeOf.get(I2CData.I2CSmbusData.class));
        try {
            SmbusData data = ptr.getData();
            ByteBuffer block = ByteBuffer.wrap(data.getBlock());
            ByteBuffer source = CTypeConversion.asByteBuffer((PointerBase)smbusData, (int)34);
            log.log(Level.FINEST, "ioctl.smbus input block: ");
            log.log(Level.FINEST, () -> StringUtils.dump((ByteBuffer)block));
            block.position(0);
            source.put(block);
            ioctl.setReadWrite(ptr.getReadWrite());
            ioctl.setCommand((byte)command);
            ioctl.setSize(ptr.getSize());
            ioctl.getData().write(smbusData);
            int result = Delegate.ioctl(fd.getHandle(), 1824L, ioctl);
            LinuxUtils.checkIOResult((String)"ioctl:SmBus", (int)result);
            block.position(0);
            source.position(0);
            block.put(source);
            log.log(Level.FINEST, "ioctl.smbus input block: ");
            log.log(Level.FINEST, () -> StringUtils.dump((ByteBuffer)block));
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)smbusData);
            UnmanagedMemory.free((PointerBase)ioctl);
        }
    }

    public int ioctl(FileHandle fd, SpiIocTransfer ptr) throws NativeIOException {
        log.log(Level.FINEST, () -> String.format("ioctl.spi fd is '%d' data is '%s'", fd.getHandle(), ptr));
        ByteBuffer txBuffer = ptr.getTxBuffer();
        ByteBuffer rxBuffer = ptr.getRxBuffer();
        int txSize = txBuffer.capacity();
        int rxSize = rxBuffer.capacity();
        log.log(Level.FINEST, () -> String.format("dump input array \n%s", StringUtils.dump((ByteBuffer)txBuffer)));
        byte[] buffer = new byte[txSize + rxSize];
        System.arraycopy(LinuxUtils.toBytes((ByteBuffer)txBuffer), 0, buffer, 0, txSize);
        SpiIocTransferNative.spi_ioc_transfer spi = (SpiIocTransferNative.spi_ioc_transfer)UnmanagedMemory.malloc((int)SizeOf.get(SpiIocTransferNative.spi_ioc_transfer.class));
        log.log(Level.FINEST, () -> String.format("pinned array \n%s", StringUtils.dump((byte[])buffer)));
        try {
            int n;
            block9: {
                PinnedObject pin = PinnedObject.create((Object)buffer);
                try {
                    CCharPointer buf = (CCharPointer)pin.addressOfArrayElement(0);
                    spi.setTxBuffer(buf);
                    spi.setRxBuffer(buf);
                    spi.setLength(ptr.getLength());
                    spi.setSpeed(ptr.getSpeed());
                    spi.setDelay(ptr.getDelay());
                    spi.setBitsPerWord(ptr.getBitsPerWord());
                    long ioc_message = this.SPI_IOC_MESSAGE(1);
                    log.log(Level.FINEST, () -> String.format("ioc_message is '%s'", ioc_message));
                    int result = Delegate.ioctl(fd.getHandle(), ioc_message, spi);
                    log.log(Level.FINEST, () -> String.format("ioctl result is '%s'", result));
                    LinuxUtils.checkIOResult((String)"ioctl:SPI", (int)result);
                    ByteBuffer out = CTypeConversion.asByteBuffer((PointerBase)buf.addressOf(txSize), (int)rxSize);
                    rxBuffer.put(out).position(0);
                    log.log(Level.FINEST, () -> String.format("dump output array \n%s", StringUtils.dump((ByteBuffer)rxBuffer)));
                    n = result;
                    if (pin == null) break block9;
                }
                catch (Throwable throwable) {
                    if (pin != null) {
                        try {
                            pin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pin.close();
            }
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)spi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle handle, long command, GpioHandleRequest request) throws NativeIOException {
        GpioNativeStructures.gpiohandle_request struct = (GpioNativeStructures.gpiohandle_request)UnmanagedMemory.malloc((int)SizeOf.get(GpioNativeStructures.gpiohandle_request.class));
        try {
            byte[] defs;
            int[] ints = request.getLineOffsets();
            if (ints != null) {
                for (int index = 0; index < ints.length; ++index) {
                    struct.lineOffsets().write(index, ints[index]);
                }
            }
            struct.flags(request.getFlags());
            struct.lines(request.getLines());
            byte[] label = request.getConsumerLabel();
            if (label != null) {
                for (int index = 0; index < label.length; ++index) {
                    struct.consumerLabel().write(index, label[index]);
                }
            }
            if ((defs = request.getDefaultValues()) != null) {
                for (int index = 0; index < defs.length; ++index) {
                    struct.defaultValues().write(index, defs[index]);
                }
            }
            int result = Delegate.ioctl(handle.getHandle(), command, struct);
            LinuxUtils.checkIOResult((String)"ioctl:gpio_handle_request", (int)result);
            request.setFd(struct.fd());
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)struct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle handle, long command, GpioChipInfo info) throws NativeIOException {
        GpioNativeStructures.gpiochip_info struct = (GpioNativeStructures.gpiochip_info)UnmanagedMemory.malloc((int)SizeOf.get(GpioNativeStructures.gpiochip_info.class));
        try {
            int result = Delegate.ioctl(handle.getHandle(), command, struct);
            info.setName(CTypeConversion.toJavaString((CCharPointer)struct.name()));
            info.setLabel(CTypeConversion.toJavaString((CCharPointer)struct.label()));
            info.setLines(struct.lines());
            LinuxUtils.checkIOResult((String)"ioctl:gpio_chip_info", (int)result);
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)struct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ioctl(FileHandle handle, long command, GpioLineInfo line) throws NativeIOException {
        GpioNativeStructures.gpioline_info struct = (GpioNativeStructures.gpioline_info)UnmanagedMemory.malloc((int)SizeOf.get(GpioNativeStructures.gpioline_info.class));
        try {
            struct.offset(line.getOffset());
            int result = Delegate.ioctl(handle.getHandle(), command, struct);
            LinuxUtils.checkIOResult((String)"ioctl:gpio_line_info", (int)result);
            line.setFlags(struct.flags());
            line.setName(CTypeConversion.toJavaString((CCharPointer)struct.name()));
            line.setConsumer(CTypeConversion.toJavaString((CCharPointer)struct.consumer()));
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)struct);
        }
    }

    public int ioctl(int fd, long command, GpioHandleData handleData) throws NativeIOException {
        Objects.requireNonNull(handleData);
        GpioNativeStructures.gpiohandle_data data = (GpioNativeStructures.gpiohandle_data)UnmanagedMemory.malloc((int)SizeOf.get(GpioNativeStructures.gpiohandle_data.class));
        byte[] from = handleData.getValues();
        CCharPointer to = data.values();
        for (int i = 0; i < from.length; ++i) {
            to.write(i, from[i]);
        }
        int result = Delegate.ioctl(fd, command, data);
        LinuxUtils.checkIOResult((String)"ioctl:byte_array_ref", (int)result);
        for (int i = 0; i < from.length; ++i) {
            from[i] = to.read(i);
        }
        return result;
    }

    protected long GET_SPI_IOC_MAGIC() {
        return IoctlNative.SPI_IOC_MAGIC();
    }

    protected long IOC_NRBITS() {
        return IoctlNative._IOC_NRBITS();
    }

    protected long IOC_TYPEBITS() {
        return IoctlNative._IOC_TYPEBITS();
    }

    protected long IOC_SIZEBITS() {
        return IoctlNative._IOC_SIZEBITS();
    }

    protected long IOC_DIRBITS() {
        return IoctlNative._IOC_DIRBITS();
    }

    protected long IOC_NRSHIFT() {
        return IoctlNative._IOC_NRSHIFT();
    }

    protected long IOC_NONE() {
        return IoctlNative._IOC_NONE();
    }

    protected long IOC_READ() {
        return IoctlNative._IOC_READ();
    }

    protected long IOC_WRITE() {
        return IoctlNative._IOC_WRITE();
    }

    protected int SPI_MSGSIZE(int N) {
        return N * SizeOf.get(SpiIocTransferNative.spi_ioc_transfer.class) < 1 << (int)this.IOC_SIZEBITS() ? N * SizeOf.get(SpiIocTransferNative.spi_ioc_transfer.class) : 0;
    }

    private static class Delegate {
        private Delegate() {
        }

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        private static native int ioctl(int var0, long var1, long var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        private static native int ioctl(int var0, long var1, CLongPointer var3);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int ioctl(int var0, long var1, PointerBase var3);
    }
}

