/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jef.java.embedded.framework.linux.core.natives;

import io.quarkiverse.jef.java.embedded.framework.linux.core.LinuxUtils;
import io.quarkiverse.jef.java.embedded.framework.linux.core.NativeIOException;
import io.quarkiverse.jef.java.embedded.framework.linux.core.Sys;
import io.quarkiverse.jef.java.embedded.framework.linux.core.natives.SysNativeHeaders;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;

@CContext(value=SysNativeHeaders.class)
@CLibrary(value="c")
public class SysNative
extends Sys {
    public long getuid() {
        return Integer.toUnsignedLong(Delegate.getuid());
    }

    public long geteuid() {
        return Integer.toUnsignedLong(Delegate.geteuid());
    }

    public int getpid() {
        return Delegate.getpid();
    }

    public boolean access(String filename, EnumSet<Sys.AccessFlag> flags) {
        try (CTypeConversion.CCharPointerHolder c = CTypeConversion.toCString((CharSequence)filename);){
            int result = Delegate.access(c.get(), this.flagToInt(flags));
            boolean bl = result == 0;
            return bl;
        }
    }

    public String getcwd() throws NativeIOException {
        byte[] bytes = new byte[4096];
        try (PinnedObject pin = PinnedObject.create((Object)bytes);){
            String string;
            block12: {
                CTypeConversion.CCharPointerHolder url = CTypeConversion.toCString((CharSequence)"/proc/self/exe");
                try {
                    CCharPointer rawData = (CCharPointer)pin.addressOfArrayElement(0);
                    int result = Delegate.readlink(url.get(), rawData, bytes.length);
                    LinuxUtils.checkIOResult((String)"getcwd", (int)result);
                    string = new String(bytes, 0, result);
                    if (url == null) break block12;
                }
                catch (Throwable throwable) {
                    if (url != null) {
                        try {
                            url.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                url.close();
            }
            return string;
        }
    }

    protected Sys.passwd getpwuid(long uid) {
        __passwd read = Delegate.getpwuid((int)uid);
        return new Sys.passwd(CTypeConversion.toJavaString((CCharPointer)read.getName()), CTypeConversion.toJavaString((CCharPointer)read.getPassword()), read.getUID(), read.getGID(), CTypeConversion.toJavaString((CCharPointer)read.getRealName()), CTypeConversion.toJavaString((CCharPointer)read.getHomeDirectory()), CTypeConversion.toJavaString((CCharPointer)read.getShell()));
    }

    protected List<Integer> getgroups() {
        int[] groups = new int[50];
        ArrayList<Integer> result = new ArrayList<Integer>();
        try (PinnedObject pin = PinnedObject.create((Object)groups);){
            int amount = Delegate.getgroups(50, pin.addressOfArrayElement(0));
            for (int i = 0; i < amount; ++i) {
                result.add(groups[i]);
            }
        }
        return result;
    }

    protected Sys.Group getgrgid(int gid) {
        __group g = Delegate.getgrgid(gid);
        return new Sys.Group(CTypeConversion.toJavaString((CCharPointer)g.getName()), CTypeConversion.toJavaString((CCharPointer)g.getPassword()), g.getGroupId());
    }

    public int execl(String command, String ... params) {
        try (CTypeConversion.CCharPointerHolder cmd = CTypeConversion.toCString((CharSequence)command);){
            int n;
            block12: {
                CTypeConversion.CCharPointerPointerHolder pr = CTypeConversion.toCStrings((CharSequence[])params);
                try {
                    n = Delegate.execl(cmd.get(), pr.get());
                    if (pr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (pr != null) {
                        try {
                            pr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pr.close();
            }
            return n;
        }
    }

    public int system(String command) {
        try (CTypeConversion.CCharPointerHolder cmd = CTypeConversion.toCString((CharSequence)command);){
            int n = Delegate.system(cmd.get());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int uname(Sys.UtcName u) {
        __new_utsname struct = (__new_utsname)UnmanagedMemory.malloc((int)SizeOf.get(__new_utsname.class));
        try {
            int result = Delegate.uname(struct);
            if (result > -1) {
                u.fill(CTypeConversion.toJavaString((CCharPointer)struct.sysname()), CTypeConversion.toJavaString((CCharPointer)struct.nodename()), CTypeConversion.toJavaString((CCharPointer)struct.release()).trim(), CTypeConversion.toJavaString((CCharPointer)struct.version()), CTypeConversion.toJavaString((CCharPointer)struct.machine()), CTypeConversion.toJavaString((CCharPointer)struct.domainname()));
            }
            int n = result;
            return n;
        }
        finally {
            UnmanagedMemory.free((PointerBase)struct);
        }
    }

    public boolean isNativeSupported() {
        return true;
    }

    private static class Delegate {
        private Delegate() {
        }

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int getuid();

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int geteuid();

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int getpid();

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int readlink(CCharPointer var0, CCharPointer var1, int var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int access(CCharPointer var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native CCharPointer getlogin();

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native __passwd getpwuid(int var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native __group getgrgid(int var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int getgroups(int var0, PointerBase var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int execl(CCharPointer var0, CCharPointerPointer var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int system(CCharPointer var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int uname(PointerBase var0);
    }

    @CStruct(value="__passwd")
    private static interface __passwd
    extends PointerBase {
        @CField(value="pw_name")
        public CCharPointer getName();

        @CField(value="pw_passwd")
        public CCharPointer getPassword();

        @CField(value="pw_uid")
        public int getUID();

        @CField(value="pw_gid")
        public int getGID();

        @CField(value="pw_gecos")
        public CCharPointer getRealName();

        @CField(value="pw_dir")
        public CCharPointer getHomeDirectory();

        @CField(value="pw_shell")
        public CCharPointer getShell();
    }

    @CStruct(value="__group")
    private static interface __group
    extends PointerBase {
        @CField(value="gr_name")
        public CCharPointer getName();

        @CField(value="gr_passwd")
        public CCharPointer getPassword();

        @CField(value="gr_gid")
        public int getGroupId();

        @CFieldAddress(value="gr_mem")
        public CCharPointer getMemberList();
    }

    @CStruct(value="__new_utsname")
    private static interface __new_utsname
    extends PointerBase {
        @CFieldAddress(value="sysname")
        public CCharPointer sysname();

        @CFieldAddress(value="nodename")
        public CCharPointer nodename();

        @CFieldAddress(value="release")
        public CCharPointer release();

        @CFieldAddress(value="version")
        public CCharPointer version();

        @CFieldAddress(value="machine")
        public CCharPointer machine();

        @CFieldAddress(value="domainname")
        public CCharPointer domainname();
    }
}

