/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jef.java.embedded.framework.linux.core.natives;

import io.quarkiverse.jef.java.embedded.framework.linux.core.LinuxUtils;
import io.quarkiverse.jef.java.embedded.framework.linux.core.Termios;
import io.quarkiverse.jef.java.embedded.framework.linux.core.io.FileHandle;
import io.quarkiverse.jef.java.embedded.framework.linux.serial.TermiosStructure;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;

@CContext(value=TermiosNativeHeaders.class)
@CLibrary(value="c")
public class TermiosNative
extends Termios {
    @CConstant
    private static native int NCCS();

    private static void fillStruct(termios2 t, TermiosStructure o) {
        t.setC_iflag(o.getC_iflag());
        t.setC_oflag(o.getC_oflag());
        t.setC_cflag(o.getC_cflag());
        t.setC_lflag(o.getC_lflag());
        t.setC_line(o.getC_line());
        t.setC_ispeed(o.getC_ispeed());
        t.setC_ospeed(o.getC_ospeed());
        byte[] c_cc = o.getC_cc();
        for (int i = 0; i < TermiosNative.NCCS(); ++i) {
            t.getC_cc().write(i, c_cc[i]);
        }
    }

    private static void updateStruct(TermiosStructure o, termios2 t) {
        o.setC_iflag(t.getC_iflag());
        o.setC_oflag(t.getC_oflag());
        o.setC_cflag(t.getC_cflag());
        o.setC_lflag(t.getC_lflag());
        o.setC_line(t.getC_line());
        o.setC_ispeed(t.getC_ispeed());
        o.setC_ospeed(t.getC_ospeed());
        byte[] c_cc = o.getC_cc();
        for (int i = 0; i < TermiosNative.NCCS(); ++i) {
            c_cc[i] = t.getC_cc().read(i);
        }
    }

    public boolean isNativeSupported() {
        return true;
    }

    public int tcgetattr(FileHandle handle, TermiosStructure ts) {
        ts.setC_cc(new byte[TermiosNative.NCCS()]);
        termios2 t = (termios2)StackValue.get(termios2.class);
        int result = Delegate.tcgetattr(handle.getHandle(), t);
        TermiosNative.updateStruct(ts, t);
        return result;
    }

    public void cfmakeraw(TermiosStructure options) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        Delegate.cfmakeraw(t);
        TermiosNative.updateStruct(options, t);
    }

    public int cfsetispeed(TermiosStructure options, int value) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        int result = Delegate.cfsetispeed(t, value);
        if (result > -1) {
            TermiosNative.updateStruct(options, t);
        }
        return result;
    }

    public int cfsetospeed(TermiosStructure options, int value) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        int result = Delegate.cfsetospeed(t, value);
        if (result > -1) {
            TermiosNative.updateStruct(options, t);
        }
        return result;
    }

    public int tcsetattr(FileHandle handle, int tcsanow, TermiosStructure options) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        int result = Delegate.tcsetattr(handle.getHandle(), tcsanow, t);
        if (result > -1) {
            TermiosNative.updateStruct(options, t);
        }
        return result;
    }

    public int cfgetispeed(TermiosStructure options) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        int result = Delegate.cfgetispeed(t);
        TermiosNative.updateStruct(options, t);
        return result;
    }

    public int cfgetospeed(TermiosStructure options) {
        termios2 t = (termios2)StackValue.get(termios2.class);
        TermiosNative.fillStruct(t, options);
        int result = Delegate.cfgetospeed(t);
        TermiosNative.updateStruct(options, t);
        return result;
    }

    public int tcflush(FileHandle handle, int queue_selector) {
        return Delegate.tcflush(handle.getHandle(), queue_selector);
    }

    public static class TermiosNativeHeaders
    implements CContext.Directives {
        public List<String> getHeaderFiles() {
            return Collections.singletonList(LinuxUtils.resolveHeader((String)"termios.h"));
        }
    }

    private static class Delegate {
        private Delegate() {
        }

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int tcflush(int var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int cfgetospeed(termios2 var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int cfgetispeed(termios2 var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int tcsetattr(int var0, int var1, termios2 var2);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int tcgetattr(int var0, termios2 var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native void cfmakeraw(termios2 var0);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int cfsetispeed(termios2 var0, int var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int cfsetospeed(termios2 var0, int var1);
    }

    @CStruct(value="termios2")
    private static interface termios2
    extends PointerBase {
        @CField(value="c_iflag")
        public int getC_iflag();

        @CField(value="c_iflag")
        public void setC_iflag(int var1);

        @CField(value="c_oflag")
        public int getC_oflag();

        @CField(value="c_oflag")
        public void setC_oflag(int var1);

        @CField(value="c_cflag")
        public int getC_cflag();

        @CField(value="c_cflag")
        public void setC_cflag(int var1);

        @CField(value="c_lflag")
        public int getC_lflag();

        @CField(value="c_lflag")
        public void setC_lflag(int var1);

        @CField(value="c_line")
        public byte getC_line();

        @CField(value="c_line")
        public void setC_line(byte var1);

        @CFieldAddress(value="c_cc")
        public CCharPointer getC_cc();

        @CField(value="c_ispeed")
        public int getC_ispeed();

        @CField(value="c_ispeed")
        public void setC_ispeed(int var1);

        @CField(value="c_ospeed")
        public int getC_ospeed();

        @CField(value="c_ospeed")
        public void setC_ospeed(int var1);
    }
}

