/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import io.quarkus.it.neo4j.Fruit;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.reactive.ResponseStatus;
import org.neo4j.driver.Driver;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.reactivestreams.Publisher;

@Path(value="reactivefruits")
@Consumes(value={"application/json"})
public class ReactiveFruitResource {
    @Inject
    Driver driver;

    static Uni<Void> sessionFinalizer(RxSession session) {
        return Uni.createFrom().publisher(session.close());
    }

    @GET
    @Produces(value={"text/event-stream"})
    public Publisher<String> get() {
        return Multi.createFrom().resource(() -> ((Driver)this.driver).rxSession(), session -> session.readTransaction(tx -> {
            RxResult result = tx.run("MATCH (f:Fruit) RETURN f.name as name ORDER BY f.name");
            return result.records();
        })).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> record.get("name").asString());
    }

    @POST
    @Produces(value={"text/plain"})
    @ResponseStatus(value=201)
    public Uni<String> create(Fruit fruit) {
        return Uni.createFrom().emitter(e -> Multi.createFrom().resource(() -> ((Driver)this.driver).rxSession(), session -> session.writeTransaction(tx -> {
            RxResult result = tx.run("CREATE (f:Fruit {name: $name}) RETURN f", Map.of("name", fruit.name));
            return result.records();
        })).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> Fruit.from(record.get("f").asNode())).subscribe().with(persistedFruit -> e.complete((Object)("/fruits/" + persistedFruit.id))));
    }
}

