/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.context.ThreadContext;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncSession;
import org.reactivestreams.Publisher;
import reactor.adapter.JdkFlowAdapter;
import reactor.core.publisher.Flux;

@Path(value="/neo4j")
public class Neo4jResource {
    @Inject
    Driver driver;
    @Inject
    ThreadContext threadContext;

    @GET
    @Path(value="/blocking")
    public String doStuffWithNeo4j() {
        try {
            Neo4jResource.createNodes(this.driver);
            Neo4jResource.readNodes(this.driver);
        }
        catch (Exception e) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            this.reportException("An error occurred while performing Neo4j operations", e, writer);
            writer.flush();
            writer.close();
            return out.toString();
        }
        return "OK";
    }

    @GET
    @Path(value="/asynchronous")
    @Produces(value={"application/json"})
    public CompletionStage<List<Integer>> doStuffWithNeo4jAsynchronous() {
        AsyncSession session = this.driver.asyncSession();
        return this.threadContext.withContextCapture(session.runAsync("UNWIND range(1, 3) AS x RETURN x")).thenCompose(cursor -> cursor.listAsync(record -> record.get("x").asInt())).whenComplete((records, error) -> {
            if (records != null) {
                System.out.println(records);
            } else {
                error.printStackTrace();
            }
        }).thenCompose(records -> session.closeAsync().thenApply(ignore -> records));
    }

    @GET
    @Path(value="/reactive")
    @Produces(value={"text/event-stream"})
    public Publisher<Integer> doStuffWithNeo4jReactive() {
        return Flux.usingWhen((Publisher)Flux.defer(() -> Flux.just((Object)this.driver.reactiveSession())), session -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)session.executeRead(tx -> {
            Flux result = JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)tx.run("UNWIND range(1, 3) AS x RETURN x", Collections.emptyMap()));
            return JdkFlowAdapter.publisherToFlowPublisher((Publisher)result.flatMap(v -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)v.records())).map(record -> record.get("x").asInt()));
        })), session -> JdkFlowAdapter.flowPublisherToFlux((Flow.Publisher)session.close())).doOnNext(System.out::println);
    }

    private static void createNodes(Driver driver) {
        try (Session session = driver.session();
             Transaction transaction = session.beginTransaction();){
            transaction.run("CREATE (f:Framework {name: $name}) - [:CAN_USE] -> (n:Database {name: 'Neo4j'})", Values.parameters((Object[])new Object[]{"name", "Quarkus"}));
            transaction.commit();
        }
    }

    private static void readNodes(Driver driver) {
        try (Session session = driver.session();
             Transaction transaction = session.beginTransaction();){
            Result result = transaction.run("MATCH (f:Framework {name: $name}) - [:CAN_USE] -> (n) RETURN f, n", Values.parameters((Object[])new Object[]{"name", "Quarkus"}));
            result.forEachRemaining(record -> System.out.printf("%s works with %s%n", record.get("n").get("name").asString(), record.get("f").get("name").asString()));
            transaction.commit();
        }
    }

    private void reportException(String errorMessage, Exception e, PrintWriter writer) {
        if (errorMessage != null) {
            writer.write(errorMessage);
            writer.write(" ");
        }
        writer.write(e.toString());
        writer.append("\n\t");
        e.printStackTrace(writer);
        writer.append("\n\t");
    }
}

