/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import io.quarkus.it.neo4j.Fruit;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.concurrent.Flow;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jboss.resteasy.reactive.ResponseStatus;
import org.neo4j.driver.Driver;
import org.neo4j.driver.reactive.ReactiveSession;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

@Path(value="reactivefruits")
@Consumes(value={"application/json"})
public class ReactiveFruitResource {
    @Inject
    Driver driver;

    static Uni<Void> sessionFinalizer(ReactiveSession session) {
        return Uni.createFrom().publisher(FlowAdapters.toPublisher((Flow.Publisher)session.close()));
    }

    @GET
    @Produces(value={"text/event-stream"})
    public Publisher<String> get() {
        return Multi.createFrom().resource(() -> ((Driver)this.driver).reactiveSession(), session -> FlowAdapters.toPublisher((Flow.Publisher)session.executeRead(tx -> {
            Flow.Publisher result = tx.run("MATCH (f:Fruit) RETURN f.name as name ORDER BY f.name");
            return FlowAdapters.toFlowPublisher((Publisher)Multi.createFrom().publisher(FlowAdapters.toPublisher((Flow.Publisher)result)).flatMap(v -> FlowAdapters.toPublisher((Flow.Publisher)v.records())));
        }))).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> record.get("name").asString());
    }

    @POST
    @Produces(value={"text/plain"})
    @ResponseStatus(value=201)
    public Uni<String> create(Fruit fruit) {
        return Uni.createFrom().emitter(e -> Multi.createFrom().resource(() -> ((Driver)this.driver).reactiveSession(), session -> FlowAdapters.toPublisher((Flow.Publisher)session.executeWrite(tx -> {
            Flow.Publisher result = tx.run("CREATE (f:Fruit {id: randomUUID(), name: $name}) RETURN f", Map.of("name", fruit.name));
            return FlowAdapters.toFlowPublisher((Publisher)Multi.createFrom().publisher(FlowAdapters.toPublisher((Flow.Publisher)result)).flatMap(v -> FlowAdapters.toPublisher((Flow.Publisher)v.records())));
        }))).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> Fruit.from(record.get("f").asNode())).subscribe().with(persistedFruit -> e.complete((Object)("/fruits/" + persistedFruit.id))));
    }
}

