/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import io.quarkus.it.neo4j.Fruit;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.context.ThreadContext;
import org.neo4j.driver.Driver;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.NoSuchRecordException;

@Path(value="/fruits")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class FruitResource {
    @Inject
    Driver driver;
    @Inject
    ThreadContext threadContext;

    @GET
    public CompletionStage<Response> get() {
        AsyncSession session = (AsyncSession)this.driver.session(AsyncSession.class);
        CompletionStage cs = session.executeReadAsync(tx -> tx.runAsync("MATCH (f:Fruit) RETURN f ORDER BY f.name").thenCompose(cursor -> cursor.listAsync(record -> Fruit.from(record.get("f").asNode()))));
        return this.threadContext.withContextCapture(cs).thenCompose(fruits -> session.closeAsync().thenApply(signal -> fruits)).thenApply(Response::ok).thenApply(Response.ResponseBuilder::build);
    }

    @POST
    public CompletionStage<Response> create(Fruit fruit) {
        AsyncSession session = (AsyncSession)this.driver.session(AsyncSession.class);
        CompletionStage cs = session.executeWriteAsync(tx -> tx.runAsync("CREATE (f:Fruit {id: randomUUID(), name: $name}) RETURN f", Map.of("name", fruit.name)).thenCompose(ResultCursor::singleAsync).thenApply(record -> Fruit.from(record.get("f").asNode())));
        return this.threadContext.withContextCapture(cs).thenCompose(persistedFruit -> session.closeAsync().thenApply(signal -> persistedFruit)).thenApply(persistedFruit -> Response.created((URI)URI.create("/fruits/" + persistedFruit.id)).build());
    }

    @GET
    @Path(value="/{id}")
    public CompletionStage<Response> getSingle(String id) {
        AsyncSession session = (AsyncSession)this.driver.session(AsyncSession.class);
        return this.threadContext.withContextCapture(session.executeReadAsync(tx -> tx.runAsync("MATCH (f:Fruit) WHERE f.id = $id RETURN f", Map.of("id", id)).thenCompose(ResultCursor::singleAsync)).handle((record, exception) -> {
            if (exception != null) {
                Throwable source = exception;
                if (exception instanceof CompletionException) {
                    source = exception.getCause();
                }
                Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                if (source instanceof NoSuchRecordException) {
                    status = Response.Status.NOT_FOUND;
                }
                return Response.status((Response.Status)status).build();
            }
            return Response.ok((Object)Fruit.from(record.get("f").asNode())).build();
        })).thenCompose(response -> session.closeAsync().thenApply(signal -> response));
    }

    @DELETE
    @Path(value="{id}")
    public CompletionStage<Response> delete(String id) {
        AsyncSession session = (AsyncSession)this.driver.session(AsyncSession.class);
        return this.threadContext.withContextCapture(session.executeWriteAsync(tx -> tx.runAsync("MATCH (f:Fruit) WHERE f.id = $id DELETE f", Map.of("id", id)).thenCompose(ResultCursor::consumeAsync))).thenCompose(response -> session.closeAsync()).thenApply(signal -> Response.noContent().build());
    }
}

