/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import org.eclipse.microprofile.context.ThreadContext;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveSession;

@Path(value="/neo4j")
public class Neo4jResource {
    @Inject
    Driver driver;
    @Inject
    ThreadContext threadContext;

    @GET
    @Path(value="/blocking")
    public String doStuffWithNeo4j() {
        try {
            Neo4jResource.createNodes(this.driver);
            Neo4jResource.readNodes(this.driver);
        }
        catch (Exception e) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            this.reportException("An error occurred while performing Neo4j operations", e, writer);
            writer.flush();
            writer.close();
            return out.toString();
        }
        return "OK";
    }

    @GET
    @Path(value="/asynchronous")
    @Produces(value={"application/json"})
    public CompletionStage<List<Integer>> doStuffWithNeo4jAsynchronous() {
        AsyncSession session = (AsyncSession)this.driver.session(AsyncSession.class);
        return this.threadContext.withContextCapture(session.runAsync("UNWIND range(1, 3) AS x RETURN x")).thenCompose(cursor -> cursor.listAsync(record -> record.get("x").asInt())).whenComplete((records, error) -> {
            if (records != null) {
                System.out.println(records);
            } else {
                error.printStackTrace();
            }
        }).thenCompose(records -> session.closeAsync().thenApply(ignore -> records));
    }

    @GET
    @Path(value="/reactive")
    @Produces(value={"text/event-stream"})
    public Multi<Integer> doStuffWithNeo4jReactive() {
        return Multi.createFrom().resource(() -> (ReactiveSession)this.driver.session(ReactiveSession.class), session -> session.executeRead(tx -> {
            Flow.Publisher result = tx.run("UNWIND range(1, 3) AS x RETURN x");
            return Multi.createFrom().publisher(result).flatMap(ReactiveResult::records).map(record -> record.get("x").asInt());
        })).withFinalizer(session -> Uni.createFrom().publisher(session.close()));
    }

    private static void createNodes(Driver driver) {
        try (Session session = driver.session();
             Transaction transaction = session.beginTransaction();){
            transaction.run("CREATE (f:Framework {name: $name}) - [:CAN_USE] -> (n:Database {name: 'Neo4j'})", Values.parameters((Object[])new Object[]{"name", "Quarkus"}));
            transaction.commit();
        }
    }

    private static void readNodes(Driver driver) {
        try (Session session = driver.session();
             Transaction transaction = session.beginTransaction();){
            Result result = transaction.run("MATCH (f:Framework {name: $name}) - [:CAN_USE] -> (n) RETURN f, n", Values.parameters((Object[])new Object[]{"name", "Quarkus"}));
            result.forEachRemaining(record -> System.out.printf("%s works with %s%n", record.get("n").get("name").asString(), record.get("f").get("name").asString()));
            transaction.commit();
        }
    }

    private void reportException(String errorMessage, Exception e, PrintWriter writer) {
        if (errorMessage != null) {
            writer.write(errorMessage);
            writer.write(" ");
        }
        writer.write(e.toString());
        writer.append("\n\t");
        e.printStackTrace(writer);
        writer.append("\n\t");
    }
}

