/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.it.neo4j;

import io.quarkus.it.neo4j.Fruit;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import java.util.concurrent.Flow;
import org.jboss.resteasy.reactive.ResponseStatus;
import org.neo4j.driver.Driver;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveSession;

@Path(value="reactivefruits")
@Consumes(value={"application/json"})
public class ReactiveFruitResource {
    @Inject
    Driver driver;

    static Uni<Void> sessionFinalizer(ReactiveSession session) {
        return Uni.createFrom().publisher(session.close());
    }

    @GET
    @Produces(value={"text/event-stream"})
    public Multi<String> get() {
        return Multi.createFrom().resource(() -> (ReactiveSession)this.driver.session(ReactiveSession.class), session -> session.executeRead(tx -> {
            Flow.Publisher result = tx.run("MATCH (f:Fruit) RETURN f.name as name ORDER BY f.name");
            return Multi.createFrom().publisher(result).flatMap(ReactiveResult::records);
        })).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> record.get("name").asString());
    }

    @POST
    @Produces(value={"text/plain"})
    @ResponseStatus(value=201)
    public Uni<String> create(Fruit fruit) {
        return Uni.createFrom().emitter(e -> Multi.createFrom().resource(() -> (ReactiveSession)this.driver.session(ReactiveSession.class), session -> session.executeWrite(tx -> {
            Flow.Publisher result = tx.run("CREATE (f:Fruit {id: randomUUID(), name: $name}) RETURN f", Map.of("name", fruit.name));
            return Multi.createFrom().publisher(result).flatMap(ReactiveResult::records);
        })).withFinalizer(ReactiveFruitResource::sessionFinalizer).map(record -> Fruit.from(record.get("f").asNode())).toUni().subscribe().with(persistedFruit -> e.complete((Object)("/fruits/" + persistedFruit.id))));
    }
}

