/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.opensearch.client.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.opensearch.OpenSearchConfig;
import io.quarkiverse.opensearch.client.runtime.OpenSearchTransportHelper;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.client.transport.OpenSearchTransport;

@ApplicationScoped
public class OpenSearchTransportProducer {
    private final Instance<ObjectMapper> objectMappers;
    private final OpenSearchConfig config;
    private Set<OpenSearchTransport> transports = new HashSet<OpenSearchTransport>();

    public OpenSearchTransportProducer(Instance<ObjectMapper> objectMappers, OpenSearchConfig config) {
        this.objectMappers = objectMappers;
        this.config = config;
    }

    @Produces
    @Singleton
    public OpenSearchTransport openSearchTransport() throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException {
        if (this.config.awsService().isPresent()) {
            return this.addTransport((OpenSearchTransport)OpenSearchTransportHelper.createAwsSdk2Transport(this.config, this.objectMappers));
        }
        return this.addTransport((OpenSearchTransport)OpenSearchTransportHelper.createApacheHttpClient5Transport(this.config, this.objectMappers));
    }

    private OpenSearchTransport addTransport(OpenSearchTransport transport) {
        this.transports.add(transport);
        return transport;
    }

    @PreDestroy
    void destroy() {
        for (OpenSearchTransport transport : this.transports) {
            try {
                transport.close();
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(ioe);
            }
        }
    }
}

