/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.cli;

import io.quarkiverse.operatorsdk.common.Files;
import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import picocli.CommandLine;

@CommandLine.Command(name="api", mixinStandardHelpOptions=true, description={"Creates a Kubernetes API based on a Fabric8 CustomResource along with the associated JOSDK Reconciler"})
public class API
implements Callable<Integer> {
    private static final Logger log = Logger.getLogger(API.class);
    private static final String SHORT_PREFIX = "-";
    private static final String OPTION_PREFIX = "--";
    @CommandLine.Option(names={"-k", "--kind"}, description={"Your API's kind, used to generate a CustomResource class with associated spec, status and Reconciler classes"}, required=true)
    private String kind;
    @CommandLine.Option(names={"-g", "--group"}, description={"Your API's group, e.g. halkyon.io, this will also be used, reversed, as package name for the generated classes"}, required=true)
    private String group;
    @CommandLine.Option(names={"-v", "--version"}, description={"Your API's version, e.g. v1beta1"}, required=true)
    private String version;
    private static final Files.MessageWriter writer = new Files.MessageWriter(){

        public void write(String message, Exception e, boolean forError) {
            if (forError) {
                log.error((Object)message, (Throwable)e);
            } else {
                log.info((Object)message);
            }
        }
    };

    @Override
    public Integer call() throws Exception {
        return Files.generateAPIFiles((String)this.group, (String)this.version, (String)this.kind, (Files.MessageWriter)writer) ? 0 : 1;
    }
}

