/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static <T> Class<T> loadClass(String className, Class<T> expected) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't find class " + className, e);
        }
    }

    public static <T> T instantiate(Class<T> toInstantiate) {
        try {
            Constructor<T> constructor = toInstantiate.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Couldn't instantiate " + toInstantiate.getName(), e);
        }
    }
}

