/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import io.javaoperatorsdk.operator.ControllerUtils;
import io.quarkiverse.operatorsdk.deployment.ValueExtractor;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

class BuildTimeHybridControllerConfiguration {
    private final ValueExtractor<BuildTimeControllerConfiguration> extractor;
    private final AnnotationInstance controllerAnnotation;
    private final AnnotationInstance delayRegistrationAnnotation;

    public BuildTimeHybridControllerConfiguration(BuildTimeControllerConfiguration externalConfiguration, AnnotationInstance controllerAnnotation, AnnotationInstance delayRegistrationAnnotation) {
        this.extractor = new ValueExtractor<BuildTimeControllerConfiguration>(externalConfiguration);
        this.controllerAnnotation = controllerAnnotation;
        this.delayRegistrationAnnotation = delayRegistrationAnnotation;
    }

    boolean generationAware() {
        return this.extractor.extract(this.controllerAnnotation, c -> c.generationAware, "generationAwareEventProcessing", AnnotationValue::asBoolean, () -> true);
    }

    Type eventType() {
        return this.extractor.extract(this.delayRegistrationAnnotation, c -> c.delayRegistrationUntilEvent.filter(s -> Void.TYPE.getName().equals(s)).map(DotName::createSimple).map(dn -> Type.create((DotName)dn, (Type.Kind)Type.Kind.CLASS)), "event", AnnotationValue::asClass, () -> null);
    }

    boolean delayedRegistration() {
        return this.extractor.extract(this.delayRegistrationAnnotation, c -> c.delayRegistrationUntilEvent.map(s -> Void.TYPE.getName().equals(s)), "event", v -> v.asClass().kind() != Type.Kind.VOID, () -> false);
    }

    String name(String resourceControllerClassName) {
        String defaultControllerName = ControllerUtils.getDefaultResourceControllerName((String)resourceControllerClassName);
        return ValueExtractor.annotationValueOrDefault(this.controllerAnnotation, "name", AnnotationValue::asString, () -> defaultControllerName);
    }
}

