/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.crd.generator.CRDGenerator;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.javaoperatorsdk.operator.ControllerUtils;
import io.javaoperatorsdk.operator.Operator;
import io.javaoperatorsdk.operator.api.Controller;
import io.javaoperatorsdk.operator.api.ResourceController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.config.Version;
import io.quarkiverse.operatorsdk.deployment.BuildTimeHybridControllerConfiguration;
import io.quarkiverse.operatorsdk.deployment.ConfigurationServiceBuildItem;
import io.quarkiverse.operatorsdk.deployment.ValueExtractor;
import io.quarkiverse.operatorsdk.runtime.BuildTimeControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.BuildTimeOperatorConfiguration;
import io.quarkiverse.operatorsdk.runtime.CRDConfiguration;
import io.quarkiverse.operatorsdk.runtime.ConfigurationServiceRecorder;
import io.quarkiverse.operatorsdk.runtime.DelayRegistrationUntil;
import io.quarkiverse.operatorsdk.runtime.OperatorProducer;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkiverse.operatorsdk.runtime.QuarkusControllerConfiguration;
import io.quarkiverse.operatorsdk.runtime.RunTimeOperatorConfiguration;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.io.Closeable;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class OperatorSDKProcessor {
    private static final Logger log = Logger.getLogger((String)OperatorSDKProcessor.class.getName());
    private static final String FEATURE = "operator-sdk";
    private static final DotName RESOURCE_CONTROLLER = DotName.createSimple((String)ResourceController.class.getName());
    private static final DotName APPLICATION_SCOPED = DotName.createSimple((String)ApplicationScoped.class.getName());
    private static final DotName CUSTOM_RESOURCE = DotName.createSimple((String)CustomResource.class.getName());
    private static final DotName CONTROLLER = DotName.createSimple((String)Controller.class.getName());
    private static final DotName DELAY_REGISTRATION = DotName.createSimple((String)DelayRegistrationUntil.class.getName());
    private BuildTimeOperatorConfiguration buildTimeConfiguration;
    private final CRDGenerator generator = new CRDGenerator();

    OperatorSDKProcessor() {
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem indexExtraClasses() {
        return new AdditionalIndexedClassesBuildItem(new String[]{Closeable.class.getName(), AutoCloseable.class.getName()});
    }

    @BuildStep
    void setup(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<FeatureBuildItem> features, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        features.produce((BuildItem)new FeatureBuildItem(FEATURE));
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.javaoperatorsdk", "operator-framework-core"));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void updateControllerConfigurations(ConfigurationServiceRecorder recorder, RunTimeOperatorConfiguration runTimeConfiguration, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer, ConfigurationServiceBuildItem serviceBuildItem) {
        Supplier supplier = recorder.configurationServiceSupplier(serviceBuildItem.getVersion(), serviceBuildItem.getControllerConfigs(), serviceBuildItem.isValidateCustomResources(), runTimeConfiguration);
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(QuarkusConfigurationService.class).scope(Singleton.class)).addType(ConfigurationService.class)).setRuntimeInit().supplier(supplier).done());
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    ConfigurationServiceBuildItem createConfigurationServiceAndOperator(OutputTargetBuildItem outputTarget, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, ConfigurationServiceRecorder recorder) {
        Version version = Utils.loadFromProperties();
        CRDConfiguration crdConfig = this.buildTimeConfiguration.crd;
        boolean validateCustomResources = this.shouldValidateCustomResources();
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection resourceControllers = index.getAllKnownImplementors(RESOURCE_CONTROLLER);
        List<QuarkusControllerConfiguration> controllerConfigs = resourceControllers.stream().filter(ci -> !Modifier.isAbstract(ci.flags())).map(ci -> this.createControllerConfiguration((ClassInfo)ci, additionalBeans, reflectionClasses, forcedReflectionClasses, index)).collect(Collectors.toList());
        if (crdConfig.generate.booleanValue()) {
            String outputDirName = crdConfig.outputDirectory;
            File outputDir = outputTarget.getOutputDirectory().resolve(outputDirName).toFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            this.generator.forCRDVersions(crdConfig.versions).inOutputDir(outputDir).generate();
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(OperatorProducer.class));
        return new ConfigurationServiceBuildItem(new io.quarkiverse.operatorsdk.runtime.Version(version.getSdkVersion(), version.getCommit(), version.getBuiltTime()), controllerConfigs, validateCustomResources);
    }

    private boolean shouldValidateCustomResources() {
        if (Utils.isValidateCustomResourcesEnvVarSet()) {
            return Utils.shouldCheckCRDAndValidateLocalModel();
        }
        boolean validateCustomResources = true;
        boolean useDeprecated = false;
        if (this.buildTimeConfiguration.checkCRDAndValidateLocalModel.isPresent()) {
            validateCustomResources = (Boolean)this.buildTimeConfiguration.checkCRDAndValidateLocalModel.get();
            useDeprecated = true;
            log.warn((Object)"Use of deprecated check-crd-and-validate-local-model property. Use crd.validate instead.");
        }
        Boolean validate = this.buildTimeConfiguration.crd.validate;
        if (useDeprecated && validate != validateCustomResources) {
            log.warnv("Deprecated property check-crd-and-validate-local-model with value ''{0}'' is overridden by crd.validate property value ''{1}''", (Object)validateCustomResources, (Object)validate);
            validateCustomResources = validate;
        }
        return validateCustomResources;
    }

    private boolean asBoolean(String value) {
        return Boolean.parseBoolean(value);
    }

    @BuildStep
    void createDelayedRegistrationObservers(CombinedIndexBuildItem combinedIndexBuildItem, ObserverRegistrationPhaseBuildItem observerRegistrationPhase, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> observerConfigurators) {
        IndexView index = combinedIndexBuildItem.getIndex();
        for (ClassInfo info : index.getAllKnownImplementors(RESOURCE_CONTROLLER)) {
            AnnotationInstance controllerAnnotation;
            String controllerClassName = info.name().toString();
            String name = this.getControllerName(controllerClassName, controllerAnnotation = info.classAnnotation(CONTROLLER));
            BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration((BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, info.classAnnotation(DELAY_REGISTRATION));
            if (!configExtractor.delayedRegistration()) continue;
            ObserverConfigurator configurator = observerRegistrationPhase.getContext().configure().observedType(configExtractor.eventType()).beanClass(info.name()).notify(mc -> {
                MethodDescriptor cdiMethod = MethodDescriptor.ofMethod(CDI.class, (String)"current", CDI.class, (Class[])new Class[0]);
                MethodDescriptor selectMethod = MethodDescriptor.ofMethod(CDI.class, (String)"select", Instance.class, (Class[])new Class[]{Class.class, Annotation[].class});
                MethodDescriptor getMethod = MethodDescriptor.ofMethod(Instance.class, (String)"get", Object.class, (Class[])new Class[0]);
                AssignableResultHandle cdiVar = mc.createVariable(CDI.class);
                mc.assign(cdiVar, mc.invokeStaticMethod(cdiMethod, new ResultHandle[0]));
                ResultHandle operatorInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{mc.loadClass(Operator.class), mc.newArray(Annotation.class, 0)});
                ResultHandle operator = mc.checkCast(mc.invokeInterfaceMethod(getMethod, operatorInstance, new ResultHandle[0]), Operator.class);
                ResultHandle resourceInstance = mc.invokeVirtualMethod(selectMethod, (ResultHandle)cdiVar, new ResultHandle[]{mc.loadClass(controllerClassName), mc.newArray(Annotation.class, 0)});
                ResultHandle resource = mc.checkCast(mc.invokeInterfaceMethod(getMethod, resourceInstance, new ResultHandle[0]), ResourceController.class);
                mc.invokeVirtualMethod(MethodDescriptor.ofMethod(Operator.class, (String)"register", Void.TYPE, (Class[])new Class[]{ResourceController.class}), operator, new ResultHandle[]{resource});
                mc.returnValue(null);
            });
            observerConfigurators.produce((BuildItem)new ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem(new ObserverConfigurator[]{configurator}));
        }
    }

    private QuarkusControllerConfiguration createControllerConfiguration(ClassInfo info, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectionClasses, BuildProducer<ForceNonWeakReflectiveClassBuildItem> forcedReflectionClasses, IndexView index) {
        String crType = ((Type)JandexUtil.resolveTypeParameters((DotName)info.name(), (DotName)RESOURCE_CONTROLLER, (IndexView)index).get(0)).name().toString();
        String resourceControllerClassName = info.name().toString();
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(resourceControllerClassName).setUnremovable().setDefaultScope(APPLICATION_SCOPED).build());
        Class<?> crClass = this.loadClass(crType);
        this.generator.customResources(new CustomResourceInfo[]{CustomResourceInfo.fromClass(crClass)});
        String crdName = CustomResource.getCRDName(crClass);
        reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{crType}));
        forcedReflectionClasses.produce((BuildItem)new ForceNonWeakReflectiveClassBuildItem(crType));
        List crParamTypes = JandexUtil.resolveTypeParameters((DotName)DotName.createSimple((String)crType), (DotName)CUSTOM_RESOURCE, (IndexView)index);
        this.registerForReflection(reflectionClasses, ((Type)crParamTypes.get(0)).name().toString());
        this.registerForReflection(reflectionClasses, ((Type)crParamTypes.get(1)).name().toString());
        AnnotationInstance controllerAnnotation = info.classAnnotation(CONTROLLER);
        AnnotationInstance delayedRegistrationAnnotation = info.classAnnotation(DELAY_REGISTRATION);
        String name = this.getControllerName(resourceControllerClassName, controllerAnnotation);
        BuildTimeHybridControllerConfiguration configExtractor = new BuildTimeHybridControllerConfiguration((BuildTimeControllerConfiguration)this.buildTimeConfiguration.controllers.get(name), controllerAnnotation, delayedRegistrationAnnotation);
        QuarkusControllerConfiguration configuration = new QuarkusControllerConfiguration(resourceControllerClassName, name, crdName, configExtractor.generationAware(), crType, configExtractor.delayedRegistration(), this.getNamespaces(controllerAnnotation), this.getFinalizer(controllerAnnotation, crdName));
        log.infov("Processed ''{0}'' controller named ''{1}'' for ''{2}'' CR (version ''{3}'')", new Object[]{info.name().toString(), name, crdName, HasMetadata.getApiVersion(crClass)});
        return configuration;
    }

    private String getControllerName(String resourceControllerClassName, AnnotationInstance controllerAnnotation) {
        String defaultControllerName = ControllerUtils.getDefaultResourceControllerName((String)resourceControllerClassName);
        return ValueExtractor.annotationValueOrDefault(controllerAnnotation, "name", AnnotationValue::asString, () -> defaultControllerName);
    }

    private Set<String> getNamespaces(AnnotationInstance controllerAnnotation) {
        return QuarkusControllerConfiguration.asSet((String[])ValueExtractor.annotationValueOrDefault(controllerAnnotation, "namespaces", AnnotationValue::asStringArray, () -> new String[0]));
    }

    private String getFinalizer(AnnotationInstance controllerAnnotation, String crdName) {
        return ValueExtractor.annotationValueOrDefault(controllerAnnotation, "finalizerName", AnnotationValue::asString, () -> ControllerUtils.getDefaultFinalizerName((String)crdName));
    }

    private void registerForReflection(BuildProducer<ReflectiveClassBuildItem> reflectionClasses, String className) {
        Optional.ofNullable(className).filter(s -> !Void.TYPE.getName().equals(className)).ifPresent(cn -> {
            reflectionClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{cn}));
            log.infov("Registered ''{0}'' for reflection", cn);
        });
    }

    private Class<?> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't find class " + className);
        }
    }
}

