/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.deployment;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

class ValueExtractor<C> {
    private final C extContConfig;

    ValueExtractor(C extContConfig) {
        this.extContConfig = extContConfig;
    }

    C getConfiguration() {
        return this.extContConfig;
    }

    <T> T extract(AnnotationInstance annotation, Function<C, Optional<T>> extractor, String annotationField, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        if (this.extContConfig != null) {
            return extractor.apply(this.extContConfig).orElse(ValueExtractor.annotationValueOrDefault(annotation, annotationField, converter, defaultValue));
        }
        return ValueExtractor.annotationValueOrDefault(annotation, annotationField, converter, defaultValue);
    }

    static <T> T annotationValueOrDefault(AnnotationInstance annotation, String name, Function<AnnotationValue, T> converter, Supplier<T> defaultValue) {
        return annotation != null ? Optional.ofNullable(annotation.value(name)).map(converter).orElseGet(defaultValue) : defaultValue.get();
    }
}

