/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class JetStreamConnectorIncomingConfiguration
extends JetStreamConnectorCommonConfiguration {
    public JetStreamConnectorIncomingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public Optional<String> getName() {
        return this.config.getOptionalValue("name", String.class);
    }

    public String getPublisherType() {
        return this.config.getOptionalValue("publisher-type", String.class).orElse("Pull");
    }

    public Optional<String> getPayloadType() {
        return this.config.getOptionalValue("payload-type", String.class);
    }

    public Optional<String> getDurable() {
        return this.config.getOptionalValue("durable", String.class);
    }

    public Optional<String> getFilterSubjects() {
        return this.config.getOptionalValue("filter-subjects", String.class);
    }

    public Optional<String> getAckWait() {
        return this.config.getOptionalValue("ack-wait", String.class);
    }

    public Optional<String> getDeliverPolicy() {
        return this.config.getOptionalValue("deliver-policy", String.class);
    }

    public Optional<String> getDescription() {
        return this.config.getOptionalValue("description", String.class);
    }

    public Optional<String> getInactiveThreshold() {
        return this.config.getOptionalValue("inactive-threshold", String.class);
    }

    public Optional<Integer> getMaxAckPending() {
        return this.config.getOptionalValue("max-ack-pending", Integer.class);
    }

    public Optional<Integer> getMaxDeliver() {
        return this.config.getOptionalValue("max-deliver", Integer.class);
    }

    public Optional<String> getReplayPolicy() {
        return this.config.getOptionalValue("replay-policy", String.class);
    }

    public Optional<Integer> getReplicas() {
        return this.config.getOptionalValue("replicas", Integer.class);
    }

    public Optional<Boolean> getMemoryStorage() {
        return this.config.getOptionalValue("memory-storage", Boolean.class);
    }

    public Optional<String> getBackOff() {
        return this.config.getOptionalValue("back-off", String.class);
    }

    public Long getRetryBackoff() {
        return this.config.getOptionalValue("retry-backoff", Long.class).orElse(Long.valueOf("10000"));
    }

    public Boolean getExponentialBackoff() {
        return this.config.getOptionalValue("exponential-backoff", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public String getExponentialBackoffMaxDuration() {
        return this.config.getOptionalValue("exponential-backoff-max-duration", String.class).orElse("PT2M");
    }

    public String getAckTimeout() {
        return this.config.getOptionalValue("ack-timeout", String.class).orElse("PT2S");
    }

    public Integer getPullBatchSize() {
        return this.config.getOptionalValue("pull.batch-size", Integer.class).orElse(Integer.valueOf("100"));
    }

    public Integer getPullRepullAt() {
        return this.config.getOptionalValue("pull.repull-at", Integer.class).orElse(Integer.valueOf("50"));
    }

    public Optional<Integer> getPullMaxWaiting() {
        return this.config.getOptionalValue("pull.max-waiting", Integer.class);
    }

    public Optional<String> getPullMaxExpires() {
        return this.config.getOptionalValue("pull.max-expires", String.class);
    }

    public Optional<Boolean> getPushOrdered() {
        return this.config.getOptionalValue("push.ordered", Boolean.class);
    }

    public Optional<String> getPushDeliverGroup() {
        return this.config.getOptionalValue("push.deliver-group", String.class);
    }

    public Optional<String> getPushFlowControl() {
        return this.config.getOptionalValue("push.flow-control", String.class);
    }

    public Optional<String> getPushIdleHeartBeat() {
        return this.config.getOptionalValue("push.idle-heart-beat", String.class);
    }

    public Optional<Long> getPushRateLimit() {
        return this.config.getOptionalValue("push.rate-limit", Long.class);
    }

    public Optional<Boolean> getPushHeadersOnly() {
        return this.config.getOptionalValue("push.headers-only", Boolean.class);
    }

    @Override
    public void validate() {
        super.validate();
    }
}

