/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream;

import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamBuildConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.administration.AdministrationConnection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.administration.JetStreamSetupException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.KeyValueSetupConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.SetupConfiguration;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import org.jboss.logging.Logger;

@Recorder
public class JetStreamRecorder {
    private static final Logger logger = Logger.getLogger(JetStreamRecorder.class);
    private final RuntimeValue<NatsConfiguration> natsConfiguration;
    private final RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration;

    public JetStreamRecorder(RuntimeValue<NatsConfiguration> natsConfiguration, RuntimeValue<JetStreamBuildConfiguration> jetStreamConfiguration) {
        this.natsConfiguration = natsConfiguration;
        this.jetStreamConfiguration = jetStreamConfiguration;
    }

    public void setupStreams() {
        if (((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue()).autoConfigure().booleanValue()) {
            try (AdministrationConnection connection = this.connect();){
                SetupConfiguration.of((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue()).forEach(setupConfiguration -> connection.addOrUpdateStream((SetupConfiguration)setupConfiguration).await().indefinitely());
                KeyValueSetupConfiguration.of((JetStreamBuildConfiguration)this.jetStreamConfiguration.getValue()).forEach(keyValueSetupConfiguration -> connection.addOrUpdateKeyValueStore((KeyValueSetupConfiguration)keyValueSetupConfiguration).await().indefinitely());
            }
            catch (Throwable failure) {
                throw new JetStreamSetupException(String.format("Unable to configure stream: %s", failure.getMessage()), failure);
            }
        }
    }

    private AdministrationConnection connect() {
        ConnectionConfiguration connectionConfiguration = ConnectionConfiguration.of((NatsConfiguration)this.natsConfiguration.getValue());
        return new AdministrationConnection(connectionConfiguration, (event, message) -> logger.infof("%s with message %s", (Object)event, (Object)message));
    }
}

