/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Connection;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionException;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.DefaultErrorListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.InternalConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.unchecked.Unchecked;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;

public abstract class AbstractConnection
implements Connection {
    private static final Logger logger = Logger.getLogger(AbstractConnection.class);
    protected final io.nats.client.Connection connection;
    private final List<ConnectionListener> listeners;

    public AbstractConnection(ConnectionConfiguration connectionConfiguration, ConnectionListener connectionListener) {
        this.connection = this.connect(connectionConfiguration);
        this.listeners = new ArrayList<ConnectionListener>(List.of(connectionListener));
    }

    @Override
    public boolean isConnected() {
        return Connection.Status.CONNECTED.equals((Object)this.connection.getStatus());
    }

    @Override
    public Uni<Void> flush(Duration duration) {
        return Uni.createFrom().item(Unchecked.supplier(() -> {
            try {
                this.connection.flush(duration);
                return null;
            }
            catch (InterruptedException | TimeoutException e) {
                throw new ConnectionException(e);
            }
        }));
    }

    @Override
    public List<ConnectionListener> listeners() {
        return this.listeners;
    }

    @Override
    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void close() throws Exception {
        try {
            this.connection.close();
        }
        catch (Throwable throwable) {
            logger.warnf(throwable, "Error closing connection: %s", (Object)throwable.getMessage());
        }
    }

    private io.nats.client.Connection connect(ConnectionConfiguration configuration) throws ConnectionException {
        try {
            Options options = this.createConnectionOptions(configuration, new InternalConnectionListener(this));
            return Nats.connect((Options)options);
        }
        catch (Throwable failure) {
            throw new ConnectionException(failure);
        }
    }

    private Options createConnectionOptions(ConnectionConfiguration configuration, io.nats.client.ConnectionListener connectionListener) throws NoSuchAlgorithmException {
        String[] servers = configuration.getServers().split(",");
        Options.Builder optionsBuilder = new Options.Builder();
        optionsBuilder.servers(servers);
        optionsBuilder.maxReconnects(0);
        optionsBuilder.connectionListener(connectionListener);
        optionsBuilder.errorListener(this.getErrorListener(configuration));
        configuration.getUsername().ifPresent(username -> optionsBuilder.userInfo(username, configuration.getPassword().orElse("")));
        configuration.getToken().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).token(arg_0));
        configuration.getCredentialPath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).credentialPath(arg_0));
        configuration.getKeystorePath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).keystorePath(arg_0));
        configuration.getKeystorePassword().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).keystorePassword(arg_0));
        configuration.getTruststorePath().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).truststorePath(arg_0));
        configuration.getKeystorePassword().map(String::toCharArray).ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).truststorePassword(arg_0));
        configuration.getBufferSize().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).bufferSize(arg_0));
        configuration.getConnectionTimeout().ifPresent(connectionTimeout -> optionsBuilder.connectionTimeout(Duration.ofMillis(connectionTimeout)));
        if (configuration.sslEnabled()) {
            optionsBuilder.opentls();
        }
        configuration.getTlsAlgorithm().ifPresent(arg_0 -> ((Options.Builder)optionsBuilder).tlsAlgorithm(arg_0));
        return optionsBuilder.build();
    }

    private ErrorListener getErrorListener(ConnectionConfiguration configuration) {
        return configuration.getErrorListener().orElseGet(DefaultErrorListener::new);
    }
}

