/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.support.Status;
import org.jboss.logging.Logger;

class DefaultErrorListener
implements ErrorListener {
    private static final Logger logger = Logger.getLogger(DefaultErrorListener.class);

    DefaultErrorListener() {
    }

    public void errorOccurred(Connection conn, String error) {
        logger.errorf("Error occurred: %s", (Object)error);
    }

    public void exceptionOccurred(Connection conn, Exception exp) {
        logger.errorf("Caught exception connecting to %s with message: %s", (Object)conn.getServers(), (Object)exp.getMessage());
    }

    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        logger.warn((Object)"Slow consumer detected");
    }

    public void messageDiscarded(Connection conn, Message msg) {
        logger.debugf("Message with id = %s discarded", (Object)msg.getSID());
    }

    public void unhandledStatus(Connection conn, JetStreamSubscription sub, Status status) {
        logger.debugf("Unhandled status: %s", (Object)status);
    }

    public void pullStatusWarning(Connection conn, JetStreamSubscription sub, Status status) {
        logger.debugf("Pull status warning with status: %s", (Object)status);
    }

    public void pullStatusError(Connection conn, JetStreamSubscription sub, Status status) {
        logger.debugf("Pull status error with status: %s", (Object)status);
    }
}

