/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client;

import io.nats.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionEvent;

class InternalConnectionListener
implements ConnectionListener {
    private final Connection connection;

    InternalConnectionListener(Connection connection) {
        this.connection = connection;
    }

    public void connectionEvent(io.nats.client.Connection connection, ConnectionListener.Events type) {
        switch (type) {
            case CONNECTED: {
                this.connection.fireEvent(ConnectionEvent.Connected, "Connection established");
                break;
            }
            case RECONNECTED: {
                this.connection.fireEvent(ConnectionEvent.Reconnected, "Connection reestablished to server");
                break;
            }
            case CLOSED: {
                this.connection.fireEvent(ConnectionEvent.Closed, "Connection closed");
                break;
            }
            case DISCONNECTED: {
                this.connection.fireEvent(ConnectionEvent.Disconnected, "Connection disconnected");
                break;
            }
            case RESUBSCRIBED: {
                this.connection.fireEvent(ConnectionEvent.Reconnected, "Connection reestablished to server");
                break;
            }
            case LAME_DUCK: {
                this.connection.fireEvent(ConnectionEvent.CommunicationFailed, "Lame duck mode");
            }
        }
    }
}

