/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration;

import io.nats.client.ErrorListener;
import io.quarkiverse.reactive.messaging.nats.NatsConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.message.MessageFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

class DefaultConnectionConfiguration
implements ConnectionConfiguration {
    private final NatsConfiguration configuration;

    DefaultConnectionConfiguration(NatsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getServers() {
        return this.configuration.servers();
    }

    @Override
    public Optional<String> getPassword() {
        return this.configuration.password();
    }

    @Override
    public Optional<String> getUsername() {
        return this.configuration.username();
    }

    @Override
    public Optional<String> getToken() {
        return this.configuration.token();
    }

    @Override
    public Optional<String> getCredentialPath() {
        return this.configuration.credentialPath();
    }

    @Override
    public boolean sslEnabled() {
        return this.configuration.sslEnabled();
    }

    @Override
    public Optional<Integer> getBufferSize() {
        return this.configuration.bufferSize();
    }

    @Override
    public Optional<ErrorListener> getErrorListener() {
        return this.configuration.errorListener().map(this::getInstanceOfErrorListener);
    }

    @Override
    public Optional<Long> getConnectionTimeout() {
        return this.configuration.connectionTimeout();
    }

    @Override
    public Optional<String> getKeystorePath() {
        return this.configuration.keystorePath();
    }

    @Override
    public Optional<String> getKeystorePassword() {
        return this.configuration.keystorePassword();
    }

    @Override
    public Optional<String> getTruststorePath() {
        return this.configuration.truststorePath();
    }

    @Override
    public Optional<String> getTruststorePassword() {
        return this.configuration.truststorePassword();
    }

    @Override
    public Optional<String> getTlsAlgorithm() {
        return this.configuration.tlsAlgorithm();
    }

    private ErrorListener getInstanceOfErrorListener(String className) {
        try {
            Class clazz = MessageFactory.loadClass(className);
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return (ErrorListener)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Not able to create instance of error listener", e);
        }
    }
}

