/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.client.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.nats.client.Message;
import io.nats.client.api.MessageInfo;
import io.quarkiverse.reactive.messaging.nats.jetstream.ExponentialBackoff;
import io.quarkiverse.reactive.messaging.nats.jetstream.JetStreamIncomingMessage;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamInstrumenter;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTrace;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import io.vertx.mutiny.core.Context;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MessageFactory {
    private static final Logger logger = Logger.getLogger(MessageFactory.class);
    public static final String MESSAGE_TYPE_HEADER = "message.type";
    private final ObjectMapper objectMapper;
    private final JetStreamInstrumenter instrumenter;

    @Inject
    public MessageFactory(ObjectMapper objectMapper, JetStreamInstrumenter instrumenter) {
        this.objectMapper = objectMapper;
        this.instrumenter = instrumenter;
    }

    public <T> org.eclipse.microprofile.reactive.messaging.Message<T> create(Message message, boolean tracingEnabled, Class<?> payloadType, Context context, ExponentialBackoff exponentialBackoff, Duration ackTimeout) {
        try {
            JetStreamIncomingMessage incomingMessage;
            JetStreamIncomingMessage<Object> jetStreamIncomingMessage = incomingMessage = payloadType != null ? new JetStreamIncomingMessage(message, this.toPayload(message, payloadType), context, exponentialBackoff, ackTimeout) : new JetStreamIncomingMessage<Object>(message, this.toPayload(message).orElseGet(() -> message.getData()), context, exponentialBackoff, ackTimeout);
            if (tracingEnabled) {
                return TracingUtils.traceIncoming(this.instrumenter.receiver(), incomingMessage, (Object)JetStreamTrace.trace(incomingMessage));
            }
            return incomingMessage;
        }
        catch (ClassCastException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray(Object payload) {
        try {
            if (payload == null) {
                return new byte[0];
            }
            if (payload instanceof byte[]) {
                byte[] byteArray = (byte[])payload;
                return byteArray;
            }
            return this.objectMapper.writeValueAsBytes(payload);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Optional<? super T> toPayload(Message message) {
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst(MESSAGE_TYPE_HEADER))).map(MessageFactory::loadClass).map(type -> this.decode(message.getData(), (Class)type));
    }

    public <T> Optional<T> toPayload(MessageInfo message) {
        logger.infof("Getting payload from message info: %s", (Object)message);
        return Optional.ofNullable(message).flatMap(m -> Optional.ofNullable(m.getHeaders())).flatMap(headers -> Optional.ofNullable(headers.getFirst(MESSAGE_TYPE_HEADER))).map(MessageFactory::loadClass).map(type -> this.decode(message.getData(), (Class)type));
    }

    public <T> T toPayload(Message message, Class<T> payLoadType) {
        return this.decode(message.getData(), payLoadType);
    }

    public <T> T decode(byte[] data, Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> loadClass(String type) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

