/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher;

import io.quarkiverse.reactive.messaging.nats.jetstream.client.Connection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionEvent;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.ConnectionListener;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.MessageSubscribeConnection;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.ConnectionConfiguration;
import io.quarkiverse.reactive.messaging.nats.jetstream.client.configuration.PushSubscribeOptionsFactory;
import io.quarkiverse.reactive.messaging.nats.jetstream.processors.Status;
import io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher.MessagePublisherProcessor;
import io.quarkiverse.reactive.messaging.nats.jetstream.processors.publisher.MessagePushPublisherConfiguration;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.jboss.logging.Logger;

public class MessagePushPublisherProcessor
implements MessagePublisherProcessor {
    private static final Logger logger = Logger.getLogger(MessagePushPublisherProcessor.class);
    private final MessagePushPublisherConfiguration<?> configuration;
    private final ConnectionFactory connectionFactory;
    private final AtomicReference<Status> status;
    private final PushSubscribeOptionsFactory optionsFactory;
    private final AtomicReference<MessageSubscribeConnection> connection;
    private final ConnectionConfiguration connectionConfiguration;

    public MessagePushPublisherProcessor(ConnectionFactory connectionFactory, ConnectionConfiguration connectionConfiguration, MessagePushPublisherConfiguration<?> configuration) {
        this.connectionConfiguration = connectionConfiguration;
        this.configuration = configuration;
        this.connectionFactory = connectionFactory;
        this.status = new AtomicReference<Status>(new Status(false, "Not connected", ConnectionEvent.Closed));
        this.optionsFactory = new PushSubscribeOptionsFactory();
        this.connection = new AtomicReference();
    }

    @Override
    public Multi<Message<?>> publisher() {
        return this.getOrEstablishConnection().onItem().transformToMulti(MessageSubscribeConnection::subscribe).onFailure().invoke(throwable -> {
            if (!this.isConsumerAlreadyInUse((Throwable)throwable)) {
                logger.errorf(throwable, "Failed to publish messages: %s", (Object)throwable.getMessage());
                MessageSubscribeConnection connection = this.connection.get();
                if (connection != null) {
                    connection.fireEvent(ConnectionEvent.CommunicationFailed, throwable.getMessage());
                }
            }
        }).onFailure().retry().withBackOff(this.configuration.retryBackoff()).indefinitely();
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public void close() {
        try {
            MessageSubscribeConnection connection = this.connection.get();
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable failure) {
            logger.warnf(failure, "Failed to close connection", (Object)failure);
        }
    }

    @Override
    public String getChannel() {
        return this.configuration.channel();
    }

    @Override
    public void onEvent(ConnectionEvent event, String message) {
        switch (event) {
            case Connected: {
                this.status.set(new Status(true, message, event));
                break;
            }
            case Closed: {
                this.status.set(new Status(false, message, event));
                break;
            }
            case Disconnected: {
                this.status.set(new Status(false, message, event));
                break;
            }
            case Reconnected: {
                this.status.set(new Status(true, message, event));
                break;
            }
            case CommunicationFailed: {
                this.status.set(new Status(false, message, event));
            }
        }
    }

    private Uni<? extends MessageSubscribeConnection> getOrEstablishConnection() {
        return Uni.createFrom().item(() -> Optional.ofNullable(this.connection.get()).filter(Connection::isConnected).orElse(null)).onItem().ifNull().switchTo(() -> this.connectionFactory.subscribe(this.connectionConfiguration, (ConnectionListener)this, this.configuration, this.optionsFactory)).onItem().invoke(this.connection::set);
    }
}

