/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.reactive.messaging.nats.jetstream.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingSpanNameExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTrace;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTraceAttributesExtractor;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTraceTextMapGetter;
import io.quarkiverse.reactive.messaging.nats.jetstream.tracing.JetStreamTraceTextMapSetter;
import io.smallrye.reactive.messaging.tracing.TracingUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;

@ApplicationScoped
public class JetStreamInstrumenter {
    private final Instance<OpenTelemetry> openTelemetryInstance;

    @Inject
    public JetStreamInstrumenter(Instance<OpenTelemetry> openTelemetryInstance) {
        this.openTelemetryInstance = openTelemetryInstance;
    }

    public Instrumenter<JetStreamTrace, Void> publisher() {
        JetStreamTraceAttributesExtractor attributesExtractor = new JetStreamTraceAttributesExtractor();
        MessagingAttributesGetter<JetStreamTrace, Void> messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)TracingUtils.getOpenTelemetry(this.openTelemetryInstance), (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND));
        return builder.addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.SEND)).addAttributesExtractor((AttributesExtractor)attributesExtractor).buildProducerInstrumenter((TextMapSetter)JetStreamTraceTextMapSetter.INSTANCE);
    }

    public Instrumenter<JetStreamTrace, Void> receiver() {
        JetStreamTraceAttributesExtractor attributesExtractor = new JetStreamTraceAttributesExtractor();
        MessagingAttributesGetter<JetStreamTrace, Void> messagingAttributesGetter = attributesExtractor.getMessagingAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)TracingUtils.getOpenTelemetry(this.openTelemetryInstance), (String)"io.smallrye.reactive.messaging.jetstream", (SpanNameExtractor)MessagingSpanNameExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE));
        return builder.addAttributesExtractor((AttributesExtractor)attributesExtractor).addAttributesExtractor(MessagingAttributesExtractor.create(messagingAttributesGetter, (MessageOperation)MessageOperation.RECEIVE)).buildConsumerInstrumenter((TextMapGetter)JetStreamTraceTextMapGetter.INSTANCE);
    }
}

